/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Random;
import org.apache.tomcat.Configuration;

public abstract class TomcatRunner
implements Runnable {
    protected static int SERVER_LISTENER_PORT;
    protected static String SERVER_SHUTDOWN_TOKEN;
    protected static boolean listenerMode;
    private Random random = null;
    protected final Configuration configuration;

    public TomcatRunner(Configuration configuration) {
        this.configuration = configuration;
        String stopPort = System.getProperty("stopport");
        if (stopPort != null) {
            try {
                SERVER_LISTENER_PORT = Integer.parseInt(stopPort);
                System.out.println("Stopport:" + SERVER_LISTENER_PORT);
            }
            catch (NumberFormatException e) {
                System.err.println("invalid stopport");
                System.exit(1);
            }
        } else if (configuration != null) {
            SERVER_LISTENER_PORT = configuration.getListenerPort();
        }
        listenerMode = SERVER_LISTENER_PORT != 0;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(SERVER_LISTENER_PORT, 1, InetAddress.getByName("localhost"));
        }
        catch (IOException e) {
            System.err.println("StandardServer.await: create[" + SERVER_LISTENER_PORT + "]: " + e.getMessage());
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                System.err.println("StandardServer.accept security exception: " + ace.getMessage() + ace.getMessage());
                continue;
            }
            catch (IOException e) {
                System.err.println("StandardServer.await: accept: " + e.getMessage());
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            for (expected = 1024; expected < SERVER_SHUTDOWN_TOKEN.length(); expected += this.random.nextInt() % 1024) {
                if (this.random != null) continue;
                this.random = new Random();
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    System.err.println("StandardServer.await: read: " + e.getMessage());
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException ch) {
                // empty catch block
            }
            boolean match = command.toString().equals(SERVER_SHUTDOWN_TOKEN);
            if (match) break;
            System.err.println("StandardServer.await: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
            this.stopServer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void stopServer();

    static {
        SERVER_SHUTDOWN_TOKEN = "SHUTDOWN";
        listenerMode = false;
    }
}

