/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat;

import java.io.File;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.Configuration;
import org.apache.tomcat.ConfigurationReader;
import org.apache.tomcat.ConnectorConfiguration;
import org.apache.tomcat.TomcatRunner;
import org.apache.tomcat.WebAppConfiguration;
import org.apache.tomcat.util.scan.StandardJarScanFilter;

public class TomcatStarter
extends TomcatRunner {
    private Tomcat tomcat;

    public TomcatStarter(Configuration configuration) {
        super(configuration);
        if (configuration == null) {
            System.err.println("-DtomcatConfig not set");
            System.exit(1);
        }
    }

    private void init() throws Exception {
        this.tomcat = new Tomcat();
        this.configuration.updateSystemProperties();
        for (WebAppConfiguration webAppConfiguration : this.configuration.getWebApps()) {
            this.createContext(webAppConfiguration);
        }
        for (int i = 0; i < this.configuration.getCountConnectorConfigurations(); ++i) {
            ConnectorConfiguration connConf = this.configuration.getConnectorConfiguration(i);
            Connector connector = this.tomcat.getConnector();
            connector.setAttribute("address", (Object)connConf.getConnectorAdress());
            connector.setPort(connConf.getConnectorPort());
            connector.setSecure(connConf.isSecure());
            connector.setURIEncoding("UTF-8");
            if (!connConf.isSecure()) continue;
            if (connConf.getClientAuth() != null) {
                connector.setProperty("clientAuth", connConf.getClientAuth());
            }
            if (connConf.getKeystoreFile() != null) {
                connector.setProperty("keystoreFile", connConf.getKeystoreFile());
            }
            if (connConf.getKeystorePass() != null) {
                connector.setProperty("keystorePass", connConf.getKeystorePass());
            }
            if (connConf.getSslProtocol() != null) {
                connector.setProperty("sslProtocol", connConf.getSslProtocol());
            }
            if (connConf.getKeyAlias() != null) {
                connector.setProperty("keyAlias", connConf.getKeyAlias());
            }
            if (connConf.getTruststoreFile() != null) {
                connector.setProperty("truststoreFile", connConf.getTruststoreFile());
            }
            if (connConf.getTruststorePass() == null) continue;
            connector.setProperty("truststorePass", connConf.getTruststorePass());
        }
    }

    private Context createContext(WebAppConfiguration webAppConfiguration) throws Exception {
        StandardContext context = (StandardContext)this.tomcat.addWebapp(webAppConfiguration.getContextPath(), new File(webAppConfiguration.getWebAppSourceDirectory()).getAbsolutePath());
        if (System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip") == null && System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip") == null) {
            StandardJarScanFilter jarScanFilter = (StandardJarScanFilter)context.getJarScanner().getJarScanFilter();
            if (webAppConfiguration.getJarsToSkip() != null) {
                jarScanFilter.setTldSkip(webAppConfiguration.getJarsToSkip());
                jarScanFilter.setPluggabilitySkip(webAppConfiguration.getJarsToSkip());
            } else if (webAppConfiguration.getJarsToScan() != null) {
                jarScanFilter.setTldScan(webAppConfiguration.getJarsToScan());
                jarScanFilter.setPluggabilityScan(webAppConfiguration.getJarsToScan());
            }
        }
        StandardManager manager = new StandardManager();
        manager.setPathname(null);
        context.setManager((Manager)manager);
        context.setParentClassLoader(this.getClass().getClassLoader());
        context.setDelegate(true);
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass("org.apache.jasper.servlet.JspServlet");
        jspServlet.addInitParameter("fork", "false");
        jspServlet.addInitParameter("xpoweredBy", "false");
        jspServlet.addInitParameter("enablePooling", "false");
        jspServlet.addInitParameter("compilerSourceVM", "1.8");
        jspServlet.addInitParameter("compilerTargetVM", "1.8");
        jspServlet.addInitParameter("javaEncoding", "UTF8");
        jspServlet.setLoadOnStartup(2);
        context.addChild((Container)jspServlet);
        context.addServletMapping("*.jsp", "jsp");
        context.addServletMapping("*.jspx", "jsp");
        context.addWelcomeFile("indexs");
        context.setSessionTimeout(30);
        context.addMimeMapping("html", "text/html");
        context.addMimeMapping("htm", "text/html");
        context.addMimeMapping("gif", "image/gif");
        context.addMimeMapping("jpg", "image/jpeg");
        context.addMimeMapping("png", "image/png");
        context.addMimeMapping("js", "text/javascript");
        context.addMimeMapping("css", "text/css");
        context.addMimeMapping("pdf", "application/pdf");
        return context;
    }

    public void startServer() throws Exception {
        this.init();
        this.tomcat.start();
    }

    @Override
    public void stopServer() {
        if (this.tomcat != null) {
            try {
                System.out.println("Shutting down MyServer...");
                this.tomcat.stop();
                System.out.println("MyServer shutdown.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration configuration = null;
        String config = System.getProperty("tomcatConfig");
        if (config == null) {
            System.err.println("-DtomcatConfig not set");
            String basedir = System.getProperty("basedir") == null ? "webApplication" : System.getProperty("basedir");
            configuration = new Configuration(basedir);
            String contextPath = System.getProperty("contextPath") == null ? "/" : System.getProperty("contextPath");
            configuration.addWebApp(contextPath, basedir, null, null);
            int port = System.getProperty("port") == null ? 8080 : Integer.parseInt(System.getProperty("port"));
            configuration.setListenerPort(port);
        } else {
            configuration = ConfigurationReader.readConfiguration(config);
        }
        TomcatStarter server = new TomcatStarter(configuration);
        server.startServer();
        Thread thread = new Thread(server);
        if (listenerMode) {
            thread.start();
            System.out.println("Stop Port activated --> " + SERVER_LISTENER_PORT);
        } else {
            server.tomcat.getServer().await();
        }
    }
}

