/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.confuse;

import com.github.akurilov.commons.collection.TreeUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public interface ConfigProvider {
    public String id();

    public Config config(String var1, Map<String, Object> var2) throws Exception;

    public static List<Config> resolve(String id, ClassLoader clsLoader, String pathSep, Map<String, Object> schema) throws Exception {
        ArrayList<Config> resolvedConfigs = new ArrayList<Config>();
        ServiceLoader<ConfigProvider> configProviderLoader = ServiceLoader.load(ConfigProvider.class, clsLoader);
        for (ConfigProvider configProvider : configProviderLoader) {
            if (!id.equals(configProvider.id())) continue;
            resolvedConfigs.add(configProvider.config(pathSep, schema));
        }
        return resolvedConfigs;
    }

    public static Config resolveAndReduce(String id, ClassLoader clsLoader, String pathSep, Map<String, Object> schema) throws Exception {
        List<Config> resolvedConfigs = ConfigProvider.resolve(id, clsLoader, pathSep, schema);
        if (resolvedConfigs == null || resolvedConfigs.size() == 0) {
            return null;
        }
        List configForest = resolvedConfigs.stream().map(c -> c.mapVal("")).collect(Collectors.toList());
        Map configTree = TreeUtil.reduceForest(configForest);
        return new BasicConfig(pathSep, schema, configTree);
    }
}

