/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Meta;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfInfoElement
extends RtfElement {
    private static final byte[] INFO_AUTHOR = DocWriter.getISOBytes("\\author");
    private static final byte[] INFO_SUBJECT = DocWriter.getISOBytes("\\subject");
    private static final byte[] INFO_KEYWORDS = DocWriter.getISOBytes("\\keywords");
    private static final byte[] INFO_TITLE = DocWriter.getISOBytes("\\title");
    private static final byte[] INFO_PRODUCER = DocWriter.getISOBytes("\\operator");
    private static final byte[] INFO_CREATION_DATE = DocWriter.getISOBytes("\\creationdate");
    private int infoType = -1;
    private String content = "";

    public RtfInfoElement(RtfDocument doc, Meta meta) {
        super(doc);
        this.infoType = meta.type();
        this.content = meta.getContent();
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        switch (this.infoType) {
            case 4: {
                result.write(INFO_AUTHOR);
                break;
            }
            case 2: {
                result.write(INFO_SUBJECT);
                break;
            }
            case 3: {
                result.write(INFO_KEYWORDS);
                break;
            }
            case 1: {
                result.write(INFO_TITLE);
                break;
            }
            case 5: {
                result.write(INFO_PRODUCER);
                break;
            }
            case 6: {
                result.write(INFO_CREATION_DATE);
                break;
            }
            default: {
                result.write(INFO_AUTHOR);
            }
        }
        result.write(DELIMITER);
        if (this.infoType == 6) {
            result.write(DocWriter.getISOBytes(this.convertDate(this.content)));
        } else {
            this.document.filterSpecialChar(result, this.content, false, false);
        }
        result.write(CLOSE_GROUP);
    }

    private String convertDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        try {
            Date creationDate = sdf.parse(date);
            sdf = new SimpleDateFormat("\\'yr'yyyy\\'mo'MM\\'dy'dd\\'hr'HH\\'min'mm\\'sec'ss");
            return sdf.format(creationDate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return "";
        }
    }
}

