/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.properties;

import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.properties.RtfPropertyListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RtfProperty {
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final String COLOR = "color.";
    public static final String CHARACTER = "character.";
    public static final String PARAGRAPH = "paragraph.";
    public static final String SECTION = "section.";
    public static final String DOCUMENT = "document.";
    public static final String COLOR_FG = "color.fg";
    public static final String COLOR_BG = "color.bg";
    public static final String CHARACTER_BOLD = "character.bold";
    public static final String CHARACTER_UNDERLINE = "character.underline";
    public static final String CHARACTER_ITALIC = "character.italic";
    public static final String CHARACTER_SIZE = "character.size";
    public static final String CHARACTER_FONT = "character.font";
    public static final String CHARACTER_STYLE = "character.style";
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int JUSTIFY_FULL = 3;
    public static final String PARAGRAPH_INDENT_LEFT = "paragraph.indentLeft";
    public static final String PARAGRAPH_INDENT_RIGHT = "paragraph.indentRight";
    public static final String PARAGRAPH_INDENT_FIRST_LINE = "paragraph.indentFirstLine";
    public static final String PARAGRAPH_JUSTIFICATION = "paragraph.justification";
    public static final String PARAGRAPH_BORDER = "paragraph.border";
    public static final String PARAGRAPH_BORDER_CELL = "paragraph.borderCell";
    public static final int PARAGRAPH_BORDER_NIL = 0;
    public static final int PARAGRAPH_BORDER_BOTTOM = 1;
    public static final int PARAGRAPH_BORDER_TOP = 2;
    public static final int PARAGRAPH_BORDER_LEFT = 4;
    public static final int PARAGRAPH_BORDER_RIGHT = 8;
    public static final int PARAGRAPH_BORDER_DIAGONAL_UL_LR = 16;
    public static final int PARAGRAPH_BORDER_DIAGONAL_UR_LL = 32;
    public static final int PARAGRAPH_BORDER_TABLE_HORIZONTAL = 64;
    public static final int PARAGRAPH_BORDER_TABLE_VERTICAL = 128;
    public static final int PGN_DECIMAL = 0;
    public static final int PGN_ROMAN_NUMERAL_UPPERCASE = 1;
    public static final int PGN_ROMAN_NUMERAL_LOWERCASE = 2;
    public static final int PGN_LETTER_UPPERCASE = 3;
    public static final int PGN_LETTER_LOWERCASE = 4;
    public static final int SBK_NONE = 0;
    public static final int SBK_COLUMN = 1;
    public static final int SBK_EVEN = 2;
    public static final int SBK_ODD = 3;
    public static final int SBK_PAGE = 4;
    public static final String SECTION_NUMBER_OF_COLUMNS = "section.numberOfColumns";
    public static final String SECTION_BREAK_TYPE = "section.SectionBreakType";
    public static final String SECTION_PAGE_NUMBER_POSITION_X = "section.pageNumberPositionX";
    public static final String SECTION_PAGE_NUMBER_POSITION_Y = "section.pageNumberPositionY";
    public static final String SECTION_PAGE_NUMBER_FORMAT = "section.pageNumberFormat";
    public static final String PAGE_PORTRAIT = "0";
    public static final String PAGE_LANDSCAPE = "1";
    public static final String DOCUMENT_PAGE_WIDTH_TWIPS = "document.pageWidthTwips";
    public static final String DOCUMENT_PAGE_HEIGHT_TWIPS = "document.pageHeightTwips";
    public static final String DOCUMENT_MARGIN_LEFT_TWIPS = "document.marginLeftTwips";
    public static final String DOCUMENT_MARGIN_TOP_TWIPS = "document.marginTopTwips";
    public static final String DOCUMENT_MARGIN_RIGHT_TWIPS = "document.marginRightTwips";
    public static final String DOCUMENT_MARGIN_BOTTOM_TWIPS = "document.marginBottomTwips";
    public static final String DOCUMENT_PAGE_NUMBER_START = "document.pageNumberStart";
    public static final String DOCUMENT_ENABLE_FACING_PAGES = "document.enableFacingPages";
    public static final String DOCUMENT_PAGE_ORIENTATION = "document.pageOrientation";
    public static final String DOCUMENT_DEFAULT_FONT_NUMER = "document.defaultFontNumber";
    protected HashMap<String, Object> properties = new HashMap();
    private boolean modifiedCharacter = false;
    private boolean modifiedParagraph = false;
    private boolean modifiedSection = false;
    private boolean modifiedDocument = false;
    private ArrayList listeners = new ArrayList();

    public void setToDefault() {
        this.setToDefault(COLOR);
        this.setToDefault(CHARACTER);
        this.setToDefault(PARAGRAPH);
        this.setToDefault(SECTION);
        this.setToDefault(DOCUMENT);
    }

    public void setToDefault(String propertyGroup) {
        if (COLOR.equals(propertyGroup)) {
            this.setProperty(COLOR_FG, new Color(0, 0, 0));
            this.setProperty(COLOR_BG, new Color(255, 255, 255));
            return;
        }
        if (CHARACTER.equals(propertyGroup)) {
            this.setProperty(CHARACTER_BOLD, 0);
            this.setProperty(CHARACTER_UNDERLINE, 0);
            this.setProperty(CHARACTER_ITALIC, 0);
            this.setProperty(CHARACTER_SIZE, 24);
            this.setProperty(CHARACTER_FONT, 0);
            return;
        }
        if (PARAGRAPH.equals(propertyGroup)) {
            this.setProperty(PARAGRAPH_INDENT_LEFT, 0);
            this.setProperty(PARAGRAPH_INDENT_RIGHT, 0);
            this.setProperty(PARAGRAPH_INDENT_FIRST_LINE, 0);
            this.setProperty(PARAGRAPH_JUSTIFICATION, 0);
            this.setProperty(PARAGRAPH_BORDER, 0);
            this.setProperty(PARAGRAPH_BORDER_CELL, 0);
            return;
        }
        if (SECTION.equals(propertyGroup)) {
            this.setProperty(SECTION_NUMBER_OF_COLUMNS, 0);
            this.setProperty(SECTION_BREAK_TYPE, 0);
            this.setProperty(SECTION_PAGE_NUMBER_POSITION_X, 0);
            this.setProperty(SECTION_PAGE_NUMBER_POSITION_Y, 0);
            this.setProperty(SECTION_PAGE_NUMBER_FORMAT, 0);
            return;
        }
        if (DOCUMENT.equals(propertyGroup)) {
            this.setProperty(DOCUMENT_PAGE_WIDTH_TWIPS, 12240);
            this.setProperty(DOCUMENT_PAGE_HEIGHT_TWIPS, 15480);
            this.setProperty(DOCUMENT_MARGIN_LEFT_TWIPS, 1800);
            this.setProperty(DOCUMENT_MARGIN_TOP_TWIPS, 1440);
            this.setProperty(DOCUMENT_MARGIN_RIGHT_TWIPS, 1800);
            this.setProperty(DOCUMENT_MARGIN_BOTTOM_TWIPS, 1440);
            this.setProperty(DOCUMENT_PAGE_NUMBER_START, 1);
            this.setProperty(DOCUMENT_ENABLE_FACING_PAGES, 1);
            this.setProperty(DOCUMENT_PAGE_ORIENTATION, PAGE_PORTRAIT);
            this.setProperty(DOCUMENT_DEFAULT_FONT_NUMER, 0);
            return;
        }
    }

    public boolean toggleProperty(RtfCtrlWordData ctrlWordData) {
        String propertyName = ctrlWordData.specialHandler;
        if (propertyName == null || propertyName.length() == 0) {
            return false;
        }
        Object propertyValue = this.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = 1;
        } else {
            if (propertyValue instanceof Integer) {
                int value = (Integer)propertyValue;
                if (value != 0) {
                    this.removeProperty(propertyName);
                }
                return true;
            }
            if (propertyValue instanceof Long) {
                long value = ((Long)propertyValue).intValue();
                if (value != 0L) {
                    this.removeProperty(propertyName);
                }
                return true;
            }
        }
        this.setProperty(propertyName, propertyValue);
        return true;
    }

    public boolean setProperty(RtfCtrlWordData ctrlWordData) {
        String propertyName = ctrlWordData.specialHandler;
        String propertyValueNew = ctrlWordData.param;
        this.setProperty(propertyName, propertyValueNew);
        return true;
    }

    private boolean setProperty(String propertyName, Object propertyValueNew) {
        long valueNew;
        int valueNew2;
        int valueOld;
        if (propertyName == null || propertyValueNew == null) {
            return false;
        }
        Object propertyValueOld = this.getProperty(propertyName);
        if (propertyValueOld instanceof Integer && propertyValueNew instanceof Integer ? (valueOld = ((Integer)propertyValueOld).intValue()) == (valueNew2 = ((Integer)propertyValueNew).intValue()) : propertyValueOld instanceof Long && propertyValueNew instanceof Long && (valueOld = (long)((Long)propertyValueOld).intValue()) == (valueNew = (long)((Long)propertyValueNew).intValue())) {
            return true;
        }
        this.beforeChange(propertyName);
        this.properties.put(propertyName, propertyValueNew);
        this.afterChange(propertyName);
        this.setModified(propertyName, true);
        return true;
    }

    private boolean setProperty(String propertyName, int propertyValueNew) {
        int valueOld;
        if (propertyName == null) {
            return false;
        }
        Object propertyValueOld = this.getProperty(propertyName);
        if (propertyValueOld instanceof Integer && (valueOld = ((Integer)propertyValueOld).intValue()) == propertyValueNew) {
            return true;
        }
        this.beforeChange(propertyName);
        this.properties.put(propertyName, propertyValueNew);
        this.afterChange(propertyName);
        this.setModified(propertyName, true);
        return true;
    }

    private boolean removeProperty(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        if (this.properties.containsKey(propertyName)) {
            this.beforeChange(propertyName);
            this.properties.remove(propertyName);
            this.afterChange(propertyName);
            this.setModified(propertyName, true);
        }
        return true;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public HashMap getProperties(String propertyGroup) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith(propertyGroup)) continue;
            props.put(key, value);
        }
        return props;
    }

    public boolean isModified() {
        return this.modifiedCharacter || this.modifiedParagraph || this.modifiedSection || this.modifiedDocument;
    }

    public void setModified(String propertyName, boolean modified) {
        if (propertyName.startsWith(CHARACTER)) {
            this.setModifiedCharacter(modified);
        } else if (propertyName.startsWith(PARAGRAPH)) {
            this.setModifiedParagraph(modified);
        } else if (propertyName.startsWith(SECTION)) {
            this.setModifiedSection(modified);
        } else if (propertyName.startsWith(DOCUMENT)) {
            this.setModifiedDocument(modified);
        }
    }

    public boolean isModifiedCharacter() {
        return this.modifiedCharacter;
    }

    public void setModifiedCharacter(boolean modifiedCharacter) {
        this.modifiedCharacter = modifiedCharacter;
    }

    public boolean isModifiedParagraph() {
        return this.modifiedParagraph;
    }

    public void setModifiedParagraph(boolean modifiedParagraph) {
        this.modifiedParagraph = modifiedParagraph;
    }

    public boolean isModifiedSection() {
        return this.modifiedSection;
    }

    public void setModifiedSection(boolean modifiedSection) {
        this.modifiedSection = modifiedSection;
    }

    public boolean isModifiedDocument() {
        return this.modifiedDocument;
    }

    public void setModifiedDocument(boolean modifiedDocument) {
        this.modifiedDocument = modifiedDocument;
    }

    public void addRtfPropertyListener(RtfPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removeRtfPropertyListener(RtfPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public void beforeChange(String propertyName) {
        for (RtfPropertyListener listener : this.listeners) {
            listener.beforePropertyChange(propertyName);
        }
        if (propertyName.startsWith(CHARACTER) || propertyName.startsWith(PARAGRAPH) || propertyName.startsWith(SECTION) || propertyName.startsWith(DOCUMENT)) {
            // empty if block
        }
    }

    public void afterChange(String propertyName) {
        for (RtfPropertyListener listener : this.listeners) {
            listener.afterPropertyChange(propertyName);
        }
        if (propertyName.startsWith(CHARACTER) || propertyName.startsWith(PARAGRAPH) || propertyName.startsWith(SECTION) || propertyName.startsWith(DOCUMENT)) {
            // empty if block
        }
    }
}

