/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBCDATASUSReader;
import com.linuxense.javadbf.DBFExploder;
import com.linuxense.javadbf.DBFExploderInputStream;
import com.linuxense.javadbf.DBFUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;

public class DBFtoDBC {
    public static void main(String[] args) {
        System.out.println("Started...");
        System.out.println(Calendar.getInstance().getTime());
        if (args.length != 2) {
            System.err.println("You must indicate source and target files");
            System.exit(1);
        }
        DBFtoDBC.convert(args[0], args[1]);
        System.out.println(Calendar.getInstance().getTime());
        System.out.println("finished...");
    }

    static void convert(String source, String target) {
        DBFtoDBC.convert(new File(source), new File(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void convert(File source, File target) {
        block5: {
            DBCDATASUSReader reader = null;
            BufferedOutputStream out = null;
            DBFExploderInputStream myInputStream = null;
            try {
                BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(source));
                reader = new DBCDATASUSReader(inStream);
                out = new BufferedOutputStream(new FileOutputStream(target));
                myInputStream = new DBFExploderInputStream(inStream);
                byte[] compressedData = myInputStream.getCompressedByteStream().toByteArray();
                int outputBufferSize = myInputStream.getAdjustedOutputSize(compressedData);
                DataOutputStream outStream = new DataOutputStream(out);
                reader.getHeader().write(outStream);
                DBFExploder.pkexplode(compressedData, DBFExploder.createOutputStreamStorage(out), outputBufferSize);
                outStream.flush();
                DBFUtils.close(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBFUtils.close(reader);
                DBFUtils.close(out);
                DBFUtils.close(myInputStream);
            }
            DBFUtils.close(out);
            DBFUtils.close(myInputStream);
        }
    }
}

