/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public final class DBFCharsetHelper {
    private DBFCharsetHelper() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static Charset getCharsetByByte(int b) {
        switch (b) {
            case 1: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 2: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 3: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 4: {
                return DBFCharsetHelper.forName("MacRoman");
            }
            case 8: {
                return DBFCharsetHelper.forName("IBM865");
            }
            case 9: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 10: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 11: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 13: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 14: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 15: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 16: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 17: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 18: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 19: {
                return DBFCharsetHelper.forName("IBM932");
            }
            case 20: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 21: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 22: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 23: {
                return DBFCharsetHelper.forName("IBM865");
            }
            case 24: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 25: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 26: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 27: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 28: {
                return DBFCharsetHelper.forName("IBM863");
            }
            case 29: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 31: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 34: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 35: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 36: {
                return DBFCharsetHelper.forName("IBM860");
            }
            case 37: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 38: {
                return DBFCharsetHelper.forName("IBM866");
            }
            case 55: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 64: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 77: {
                return DBFCharsetHelper.forName("IBM936");
            }
            case 78: {
                return DBFCharsetHelper.forName("IBM949");
            }
            case 79: {
                return DBFCharsetHelper.forName("IBM950");
            }
            case 80: {
                return DBFCharsetHelper.forName("IBM874");
            }
            case 87: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 88: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 89: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 100: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 101: {
                return DBFCharsetHelper.forName("IBM866");
            }
            case 102: {
                return DBFCharsetHelper.forName("IBM865");
            }
            case 103: {
                return DBFCharsetHelper.forName("IBM861");
            }
            case 104: {
                return DBFCharsetHelper.forName("IBM895");
            }
            case 105: {
                return DBFCharsetHelper.forName("IBM620");
            }
            case 106: {
                return DBFCharsetHelper.forName("x-IBM737");
            }
            case 107: {
                return DBFCharsetHelper.forName("IBM857");
            }
            case 108: {
                return DBFCharsetHelper.forName("IBM863");
            }
            case 120: {
                return DBFCharsetHelper.forName("windows-950");
            }
            case 121: {
                return Charset.forName("windows-949");
            }
            case 122: {
                return DBFCharsetHelper.forName("GBK");
            }
            case 123: {
                return DBFCharsetHelper.forName("windows-932");
            }
            case 124: {
                return DBFCharsetHelper.forName("windows-874");
            }
            case 125: {
                return DBFCharsetHelper.forName("windows-1255");
            }
            case 126: {
                return DBFCharsetHelper.forName("windows-1256");
            }
            case 134: {
                return DBFCharsetHelper.forName("IBM737");
            }
            case 135: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 136: {
                return DBFCharsetHelper.forName("IBM857");
            }
            case 150: {
                return DBFCharsetHelper.forName("x-MacCyrillic");
            }
            case 151: {
                return DBFCharsetHelper.forName("x-MacCentralEurope");
            }
            case 152: {
                return DBFCharsetHelper.forName("x-MacGreek");
            }
            case 200: {
                return DBFCharsetHelper.forName("windows-1250");
            }
            case 201: {
                return DBFCharsetHelper.forName("windows-1251");
            }
            case 202: {
                return DBFCharsetHelper.forName("windows-1254");
            }
            case 203: {
                return DBFCharsetHelper.forName("windows-1253");
            }
            case 204: {
                return DBFCharsetHelper.forName("IBM1257");
            }
        }
        return null;
    }

    private static Charset forName(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    public static int getDBFCodeForCharset(Charset charset) {
        if (charset == null) {
            return 0;
        }
        String charsetName = charset.toString();
        if ("ibm437".equalsIgnoreCase(charsetName)) {
            return 1;
        }
        if ("ibm850".equalsIgnoreCase(charsetName)) {
            return 2;
        }
        if ("windows-1252".equalsIgnoreCase(charsetName)) {
            return 3;
        }
        if ("iso-8859-1".equalsIgnoreCase(charsetName)) {
            return 3;
        }
        if ("MacRoman".equalsIgnoreCase(charsetName)) {
            return 4;
        }
        if ("IBM437".equalsIgnoreCase(charsetName)) {
            return 9;
        }
        if ("IBM932".equalsIgnoreCase(charsetName)) {
            return 19;
        }
        if ("IBM863".equalsIgnoreCase(charsetName)) {
            return 28;
        }
        if ("IBM852".equalsIgnoreCase(charsetName)) {
            return 31;
        }
        if ("IBM860".equalsIgnoreCase(charsetName)) {
            return 36;
        }
        if ("IBM936".equalsIgnoreCase(charsetName)) {
            return 77;
        }
        if ("IBM949".equalsIgnoreCase(charsetName)) {
            return 78;
        }
        if ("IBM950".equalsIgnoreCase(charsetName)) {
            return 79;
        }
        if ("IBM874".equalsIgnoreCase(charsetName)) {
            return 80;
        }
        if ("IBM852".equalsIgnoreCase(charsetName)) {
            return 100;
        }
        if ("IBM866".equalsIgnoreCase(charsetName)) {
            return 101;
        }
        if ("IBM865".equalsIgnoreCase(charsetName)) {
            return 102;
        }
        if ("IBM861".equalsIgnoreCase(charsetName)) {
            return 103;
        }
        if ("IBM895".equalsIgnoreCase(charsetName)) {
            return 104;
        }
        if ("IBM620".equalsIgnoreCase(charsetName)) {
            return 105;
        }
        if ("IBM737".equalsIgnoreCase(charsetName)) {
            return 106;
        }
        if ("IBM857".equalsIgnoreCase(charsetName)) {
            return 107;
        }
        if ("IBM863".equalsIgnoreCase(charsetName)) {
            return 108;
        }
        if ("IBM737".equalsIgnoreCase(charsetName)) {
            return 134;
        }
        if ("windows-950".equalsIgnoreCase(charsetName)) {
            return 120;
        }
        if ("windows-949".equalsIgnoreCase(charsetName)) {
            return 121;
        }
        if ("gbk".equalsIgnoreCase(charsetName)) {
            return 122;
        }
        if ("windows-932".equalsIgnoreCase(charsetName)) {
            return 123;
        }
        if ("windows-874".equalsIgnoreCase(charsetName)) {
            return 124;
        }
        if ("windows-1255".equalsIgnoreCase(charsetName)) {
            return 125;
        }
        if ("windows-1256".equalsIgnoreCase(charsetName)) {
            return 126;
        }
        if ("IBM852".equalsIgnoreCase(charsetName)) {
            return 135;
        }
        if ("IBM857".equalsIgnoreCase(charsetName)) {
            return 136;
        }
        if ("x-MacCyrillic".equalsIgnoreCase(charsetName)) {
            return 150;
        }
        if ("x-MacCentralEurope".equalsIgnoreCase(charsetName)) {
            return 151;
        }
        if ("x-MacGreek".equalsIgnoreCase(charsetName)) {
            return 152;
        }
        if ("windows-1250".equalsIgnoreCase(charsetName)) {
            return 200;
        }
        if ("windows-1251".equalsIgnoreCase(charsetName)) {
            return 201;
        }
        if ("windows-1254".equalsIgnoreCase(charsetName)) {
            return 202;
        }
        if ("windows-1253".equalsIgnoreCase(charsetName)) {
            return 203;
        }
        if ("IBM1257".equalsIgnoreCase(charsetName)) {
            return 204;
        }
        return 0;
    }
}

