/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFAlignment;
import com.linuxense.javadbf.DBFBase;
import com.linuxense.javadbf.DBFCharsetHelper;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFHeader;
import com.linuxense.javadbf.DBFStandardCharsets;
import com.linuxense.javadbf.DBFUtils;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DBFWriter
extends DBFBase
implements Closeable {
    private DBFHeader header;
    private List<Object[]> v_records = new ArrayList<Object[]>();
    private int recordCount = 0;
    private RandomAccessFile raf = null;
    private OutputStream outputStream = null;
    private boolean closed = false;

    @Deprecated
    public DBFWriter() {
        this(DEFAULT_CHARSET);
    }

    @Deprecated
    public DBFWriter(Charset charset) {
        this.setCharset(charset);
        this.header = new DBFHeader();
        this.header.setUsedCharset(charset);
    }

    public DBFWriter(OutputStream out) {
        this(out, DEFAULT_CHARSET);
    }

    public DBFWriter(OutputStream out, Charset charset) {
        this.setCharset(charset);
        this.header = new DBFHeader();
        this.header.setUsedCharset(charset);
        this.outputStream = out;
    }

    public DBFWriter(File dbfFile) {
        this(dbfFile, null);
    }

    public DBFWriter(File dbfFile, Charset charset) {
        try {
            this.raf = new RandomAccessFile(dbfFile, "rw");
            this.header = new DBFHeader();
            if (dbfFile.length() == 0L) {
                if (charset != null) {
                    if (DBFCharsetHelper.getDBFCodeForCharset(charset) == 0 && !DBFStandardCharsets.UTF_8.equals(charset)) {
                        throw new DBFException("Unssuported charset " + charset);
                    }
                    this.setCharset(charset);
                    this.header.setUsedCharset(charset);
                } else {
                    this.setCharset(DBFStandardCharsets.ISO_8859_1);
                    this.header.setUsedCharset(DBFStandardCharsets.ISO_8859_1);
                }
                return;
            }
            this.header.read(this.raf, charset, false);
            this.setCharset(this.header.getUsedCharset());
            if (this.raf.length() > (long)this.header.headerLength) {
                this.raf.seek(this.raf.length() - 1L);
            } else {
                this.raf.seek(this.raf.length());
            }
        }
        catch (FileNotFoundException e) {
            throw new DBFException("Specified file is not found. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage() + " while reading header", e);
        }
        this.recordCount = this.header.numberOfRecords;
    }

    public void setFields(DBFField[] fields) {
        if (this.closed) {
            throw new IllegalStateException("You can not set fields to a closed DBFWriter");
        }
        try {
            if (this.raf != null && this.raf.length() > 0L) {
                throw new DBFException("You can not change fields on an existing file");
            }
        }
        catch (IOException e) {
            throw new DBFException("Error accesing file:" + e.getMessage(), e);
        }
        if (this.header.fieldArray != null) {
            throw new DBFException("Fields has already been set");
        }
        if (fields == null || fields.length == 0) {
            throw new DBFException("Should have at least one field");
        }
        if (fields.length > 255) {
            throw new DBFException("Exceded column limit of 255 (" + fields.length + ")");
        }
        ArrayList<Integer> fieldsWithNull = new ArrayList<Integer>();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) continue;
            fieldsWithNull.add(i);
        }
        if (!fieldsWithNull.isEmpty()) {
            if (fieldsWithNull.size() == 1) {
                throw new DBFException("Field " + fieldsWithNull.get(0) + " is null");
            }
            throw new DBFException("Fields " + ((Object)fieldsWithNull).toString() + " are null");
        }
        for (DBFField field : fields) {
            if (field.getType().isWriteSupported()) continue;
            throw new DBFException("Field " + field.getName() + " is of type " + (Object)((Object)field.getType()) + " that is not supported for writting");
        }
        this.header.fieldArray = new DBFField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.header.fieldArray[i] = new DBFField(fields[i]);
        }
        try {
            if (this.raf != null && this.raf.length() == 0L) {
                this.header.write(this.raf);
            }
        }
        catch (IOException e) {
            throw new DBFException("Error accesing file:" + e.getMessage(), e);
        }
    }

    public void addRecord(Object[] values) {
        if (this.closed) {
            throw new IllegalStateException("You can add records a closed DBFWriter");
        }
        if (this.header.fieldArray == null) {
            throw new DBFException("Fields should be set before adding records");
        }
        if (values == null) {
            throw new DBFException("Null cannot be added as row");
        }
        if (values.length != this.header.fieldArray.length) {
            throw new DBFException("Invalid record. Invalid number of fields in row");
        }
        block8: for (int i = 0; i < this.header.fieldArray.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            switch (this.header.fieldArray[i].getType()) {
                case CHARACTER: {
                    if (value instanceof String) continue block8;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case LOGICAL: {
                    if (value instanceof Boolean) continue block8;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case DATE: {
                    if (value instanceof Date) continue block8;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case NUMERIC: 
                case FLOATING_POINT: {
                    if (value instanceof Number) continue block8;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                default: {
                    throw new DBFException("Unsupported writting of field type " + i + " " + (Object)((Object)this.header.fieldArray[i].getType()));
                }
            }
        }
        if (this.raf == null) {
            this.v_records.add(values);
        } else {
            try {
                this.writeRecord(this.raf, values);
                ++this.recordCount;
            }
            catch (IOException e) {
                throw new DBFException("Error occured while writing record. " + e.getMessage(), e);
            }
        }
    }

    private void writeToStream(OutputStream out) {
        try {
            DataOutputStream outStream = new DataOutputStream(out);
            this.header.numberOfRecords = this.v_records.size();
            this.header.write(outStream);
            for (Object[] record : this.v_records) {
                this.writeRecord(outStream, record);
            }
            outStream.write(26);
            outStream.flush();
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.raf != null) {
            try {
                this.header.numberOfRecords = this.recordCount;
                this.raf.seek(0L);
                this.header.write(this.raf);
                this.raf.seek(this.raf.length());
                this.raf.writeByte(26);
            }
            catch (IOException e) {
                throw new DBFException(e.getMessage(), e);
            }
            finally {
                DBFUtils.close(this.raf);
            }
        }
        if (this.outputStream != null) {
            try {
                this.writeToStream(this.outputStream);
            }
            finally {
                DBFUtils.close(this.outputStream);
            }
        }
    }

    private void writeRecord(DataOutput dataOutput, Object[] objectArray) throws IOException {
        dataOutput.write(32);
        block6: for (int j = 0; j < this.header.fieldArray.length; ++j) {
            switch (this.header.fieldArray[j].getType()) {
                case CHARACTER: {
                    String strValue = "";
                    if (objectArray[j] != null) {
                        strValue = objectArray[j].toString();
                    }
                    dataOutput.write(DBFUtils.textPadding(strValue, this.getCharset(), this.header.fieldArray[j].getLength(), DBFAlignment.LEFT, (byte)32));
                    continue block6;
                }
                case DATE: {
                    if (objectArray[j] != null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime((Date)objectArray[j]);
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(1)), DBFStandardCharsets.US_ASCII, 4, DBFAlignment.RIGHT, (byte)48));
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(2) + 1), DBFStandardCharsets.US_ASCII, 2, DBFAlignment.RIGHT, (byte)48));
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(5)), DBFStandardCharsets.US_ASCII, 2, DBFAlignment.RIGHT, (byte)48));
                        continue block6;
                    }
                    dataOutput.write("        ".getBytes(DBFStandardCharsets.US_ASCII));
                    continue block6;
                }
                case NUMERIC: 
                case FLOATING_POINT: {
                    if (objectArray[j] != null) {
                        dataOutput.write(DBFUtils.doubleFormating((Number)objectArray[j], this.getCharset(), this.header.fieldArray[j].getLength(), this.header.fieldArray[j].getDecimalCount()));
                        continue block6;
                    }
                    dataOutput.write(DBFUtils.textPadding(" ", this.getCharset(), this.header.fieldArray[j].getLength(), DBFAlignment.RIGHT, (byte)32));
                    continue block6;
                }
                case LOGICAL: {
                    if (objectArray[j] instanceof Boolean) {
                        if (((Boolean)objectArray[j]).booleanValue()) {
                            dataOutput.write(84);
                            continue block6;
                        }
                        dataOutput.write(70);
                        continue block6;
                    }
                    dataOutput.write(63);
                    continue block6;
                }
                default: {
                    throw new DBFException("Unknown field type " + (Object)((Object)this.header.fieldArray[j].getType()));
                }
            }
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected RandomAccessFile getRamdonAccessFile() {
        return this.raf;
    }

    @Deprecated
    public void write(OutputStream out) {
        if (this.raf == null) {
            this.writeToStream(out);
        }
    }

    @Deprecated
    public void write() {
        this.close();
    }
}

