/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.complete;

import caseapp.core.complete.CompletionItem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public final class Zsh$ {
    public static Zsh$ MODULE$;
    private final String shellName;
    private final String id;

    static {
        new Zsh$();
    }

    public String shellName() {
        return this.shellName;
    }

    public String id() {
        return this.id;
    }

    public String script(String progName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("#compdef _").append(progName).append(" ").append(progName).append("\n       |\n       |function _").append(progName).append(" {\n       |  eval \"$(").append(progName).append(" complete ").append(this.id()).append(" $CURRENT $words[@])\"\n       |}\n       |").toString())).stripMargin();
    }

    private String hash(Iterator<String> content) {
        int hash = MurmurHash3$.MODULE$.arrayHash(content.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (hash < 0) {
            return Integer.toString(hash * -1);
        }
        return Integer.toString(hash);
    }

    private String escape(String input) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(input.replace("'", "\\'").replace("`", "\\`").replace("|", "\\|"))).linesIterator().take(1).toList().headOption().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
    }

    private Seq<String> defs(CompletionItem item) {
        Nil$ nil$;
        Nil$ optionsOutput;
        Nil$ nil$2;
        Tuple2 tuple2 = item.values().partition((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq options = (Seq)tuple2._1();
        Seq arguments = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)options, (Object)arguments);
        Seq options2 = (Seq)tuple22._1();
        Seq arguments2 = (Seq)tuple22._2();
        if (options2.isEmpty()) {
            nil$2 = Nil$.MODULE$;
        } else {
            Seq escapedOptions = options2;
            String desc2 = (String)item.description().map((Function1 & java.io.Serializable & Serializable)desc -> new StringBuilder(1).append(":").append(MODULE$.escape((String)desc)).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            nil$2 = optionsOutput = (Seq)options2.map((Function1 & java.io.Serializable & Serializable)opt -> new StringBuilder(2).append("\"").append((String)opt).append(desc2).append("\"").toString(), Seq$.MODULE$.canBuildFrom());
        }
        if (arguments2.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String desc3 = (String)item.description().map((Function1 & java.io.Serializable & Serializable)desc -> new StringBuilder(1).append(":").append(MODULE$.escape((String)desc)).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            nil$ = (Seq)arguments2.map((Function1 & java.io.Serializable & Serializable)x$3 -> new StringBuilder(2).append("'").append(x$3.replace(":", "\\:")).append(desc3).append("'").toString(), Seq$.MODULE$.canBuildFrom());
        }
        Nil$ argumentsOutput = nil$;
        return (Seq)optionsOutput.$plus$plus((GenTraversableOnce)argumentsOutput, Seq$.MODULE$.canBuildFrom());
    }

    private String render(Seq<String> commands) {
        if (commands.isEmpty()) {
            return new StringBuilder(6).append("_files").append(System.lineSeparator()).toString();
        }
        String id = this.hash((Iterator<String>)commands.iterator());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("local -a args").append(id).append("\n         |args").append(id).append("=(\n         |").append(commands.mkString(System.lineSeparator())).append("\n         |)\n         |_describe command args").append(id).append("\n         |").toString())).stripMargin();
    }

    public String print(Seq<CompletionItem> items) {
        return this.render((Seq<String>)((Seq)items.flatMap((Function1 & java.io.Serializable & Serializable)x$4 -> MODULE$.defs((CompletionItem)x$4), Seq$.MODULE$.canBuildFrom())));
    }

    private Zsh$() {
        MODULE$ = this;
        this.shellName = "zsh";
        this.id = new StringBuilder(3).append(this.shellName()).append("-v1").toString();
    }
}

