/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.util.fansi;

import caseapp.core.util.fansi.Attr;
import caseapp.core.util.fansi.Attr$;
import caseapp.core.util.fansi.Back$;
import caseapp.core.util.fansi.Color$;
import caseapp.core.util.fansi.ColorCategory;
import caseapp.core.util.fansi.ErrorMode;
import caseapp.core.util.fansi.ErrorMode$Throw$;
import caseapp.core.util.fansi.Str;
import caseapp.core.util.fansi.Trie;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Str$
implements scala.Serializable {
    public static Str$ MODULE$;
    private final Pattern ansiRegex;
    private final Trie<Either<Attr, ColorCategory>> ParseMap;

    static {
        new Str$();
    }

    public Str implicitApply(CharSequence raw) {
        return this.apply(raw, this.apply$default$2());
    }

    public Pattern ansiRegex() {
        return this.ansiRegex;
    }

    public Str apply(CharSequence raw, ErrorMode errorMode) {
        char[] chars = new char[raw.length()];
        long[] colors = new long[raw.length()];
        long currentColor = 0L;
        IntRef sourceIndex = IntRef.create((int)0);
        int destIndex = 0;
        int length = raw.length();
        while (sourceIndex.elem < length) {
            char c = raw.charAt(sourceIndex.elem);
            if (c == '\u001b' || c == '\u009b') {
                int escapeStartSourceIndex = sourceIndex.elem;
                Option<Tuple2<Object, Either<Attr, ColorCategory>>> option = this.ParseMap.query(raw, escapeStartSourceIndex);
                if (None$.MODULE$.equals(option)) {
                    sourceIndex.elem = errorMode.handle(sourceIndex.elem, raw);
                    continue;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Tuple2 tuple = (Tuple2)some.value();
                    Tuple2 tuple2 = tuple;
                    if (tuple2 != null) {
                        int newIndex = tuple2._1$mcI$sp();
                        Either either = (Either)tuple2._2();
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            Attr color = (Attr)left.value();
                            currentColor = color.transform(currentColor);
                            sourceIndex.elem += newIndex;
                            continue;
                        }
                    }
                    if (tuple2 != null) {
                        int newIndex = tuple2._1$mcI$sp();
                        Either either = (Either)tuple2._2();
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            ColorCategory category = (ColorCategory)right.value();
                            sourceIndex.elem += newIndex;
                            if (!Str$.isDigit$1(sourceIndex.elem, raw)) {
                                Str$.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            int r = Str$.getNumber$1(sourceIndex, raw);
                            if (!Str$.checkChar$1(sourceIndex.elem, ';', raw) || !Str$.isDigit$1(sourceIndex.elem + 1, raw)) {
                                Str$.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            int g = Str$.getNumber$1(sourceIndex, raw);
                            if (!Str$.checkChar$1(sourceIndex.elem, ';', raw) || !Str$.isDigit$1(sourceIndex.elem + 1, raw)) {
                                Str$.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            int b = Str$.getNumber$1(sourceIndex, raw);
                            if (!Str$.checkChar$1(sourceIndex.elem, 'm', raw)) {
                                Str$.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            if (0 > r || r >= 256 || 0 > g || g >= 256 || 0 > b || b >= 256) {
                                Str$.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            currentColor = currentColor & (long)(~category.mask()) | (long)(273 + category.trueIndex(r, g, b) << category.offset());
                            continue;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError(option);
            }
            colors[destIndex] = currentColor;
            chars[destIndex] = c;
            ++sourceIndex.elem;
            ++destIndex;
        }
        return this.apply(Arrays.copyOfRange(chars, 0, destIndex), Arrays.copyOfRange(colors, 0, destIndex));
    }

    public ErrorMode apply$default$2() {
        return ErrorMode$Throw$.MODULE$;
    }

    public Str fromArrays(char[] chars, long[] colors) {
        return new Str((char[])chars.clone(), (long[])colors.clone());
    }

    public Str join(Seq<Str> args) {
        int length = BoxesRunTime.unboxToInt((Object)args.iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        char[] chars = new char[length];
        long[] colors = new long[length];
        IntRef j = IntRef.create((int)0);
        args.foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Str$.$anonfun$join$2(chars, j, colors, arg);
            return BoxedUnit.UNIT;
        });
        return this.fromArrays(chars, colors);
    }

    public Str apply(char[] chars, long[] colors) {
        return new Str(chars, colors);
    }

    public Option<Tuple2<char[], long[]>> unapply(Str x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.caseapp$core$util$fansi$Str$$chars(), (Object)x$0.caseapp$core$util$fansi$Str$$colors()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final boolean isDigit$1(int index, CharSequence raw$1) {
        return index < raw$1.length() && raw$1.charAt(index) >= '0' && raw$1.charAt(index) <= '9';
    }

    private static final boolean checkChar$1(int index, char c, CharSequence raw$1) {
        return index < raw$1.length() && raw$1.charAt(index) == c;
    }

    private static final void fail$1(IntRef sourceIndex$1, ErrorMode errorMode$1, int escapeStartSourceIndex$1, CharSequence raw$1) {
        sourceIndex$1.elem = errorMode$1.handle(escapeStartSourceIndex$1, raw$1);
    }

    private static final int getNumber$1(IntRef sourceIndex$1, CharSequence raw$1) {
        int value = 0;
        for (int count = 0; Str$.isDigit$1(sourceIndex$1.elem, raw$1) && count < 3; ++count) {
            value = value * 10 + (raw$1.charAt(sourceIndex$1.elem) - 48);
            ++sourceIndex$1.elem;
        }
        return value;
    }

    public static final /* synthetic */ void $anonfun$join$2(char[] chars$1, IntRef j$1, long[] colors$1, Str arg) {
        int i = 0;
        while (i < arg.length()) {
            chars$1[j$1.elem] = arg.getChar(i);
            colors$1[j$1.elem] = arg.getColor(i);
            ++i;
            ++j$1.elem;
        }
    }

    private Str$() {
        MODULE$ = this;
        this.ansiRegex = new StringOps(Predef$.MODULE$.augmentString("(\u009b|\u001b\\[)[0-?]*[ -\\/]*[@-~]")).r().pattern();
        Vector pairs = (Vector)Attr$.MODULE$.categories().flatMap((Function1 & Serializable & scala.Serializable)cat -> (Vector)cat.all().flatMap((Function1 & Serializable & scala.Serializable)color -> Option$.MODULE$.option2Iterable(color.escapeOpt().map((Function1 & Serializable & scala.Serializable)str -> new Tuple2(str, (Object)package$.MODULE$.Left().apply(color)))), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
        Seq reset = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"\u001b[0m"), (Object)package$.MODULE$.Left().apply((Object)Attr$.MODULE$.Reset())), (List)Nil$.MODULE$);
        Seq trueColors = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"\u001b[38;2;"), (Object)package$.MODULE$.Right().apply((Object)Color$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"\u001b[48;2;"), (Object)package$.MODULE$.Right().apply((Object)Back$.MODULE$)), (List)Nil$.MODULE$));
        this.ParseMap = new Trie((Seq)((Vector)pairs.$plus$plus((GenTraversableOnce)reset, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)trueColors, Vector$.MODULE$.canBuildFrom()));
    }
}

