/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.util.fansi;

import caseapp.core.util.fansi.Attr;
import caseapp.core.util.fansi.Attr$;
import caseapp.core.util.fansi.Back$;
import caseapp.core.util.fansi.Color$;
import caseapp.core.util.fansi.ColorCategory;
import caseapp.core.util.fansi.ErrorMode;
import caseapp.core.util.fansi.ErrorMode$Throw$;
import caseapp.core.util.fansi.Str;
import caseapp.core.util.fansi.Trie;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Str$
implements Mirror.Product,
Serializable {
    private static final Pattern ansiRegex;
    private static final Trie<Either<Attr, ColorCategory>> ParseMap;
    public static final Str$ MODULE$;

    private Str$() {
    }

    static {
        MODULE$ = new Str$();
        ansiRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\u009b|\u001b\\[)[0-?]*[ -\\/]*[@-~]")).pattern();
        Vector pairs = (Vector)Attr$.MODULE$.categories().flatMap((Function1 & Serializable)cat -> (IterableOnce)cat.all().flatMap((Function1 & Serializable)color -> color.escapeOpt().map((Function1 & Serializable)str -> Tuple2$.MODULE$.apply(str, (Object)package$.MODULE$.Left().apply(color)))));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[0m");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.Left().apply((Object)Attr$.MODULE$.Reset()));
        Seq reset = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[38;2;");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package$.MODULE$.Right().apply((Object)Color$.MODULE$));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[48;2;");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)package$.MODULE$.Right().apply((Object)Back$.MODULE$));
        Seq trueColors = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        ParseMap = new Trie((Seq)((IterableOps)pairs.$plus$plus((IterableOnce)reset)).$plus$plus((IterableOnce)trueColors));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Str$.class);
    }

    public Str caseapp$core$util$fansi$Str$$$apply(char[] chars, long[] colors) {
        return new Str(chars, colors);
    }

    public Str unapply(Str x$1) {
        return x$1;
    }

    public String toString() {
        return "Str";
    }

    public Str implicitApply(CharSequence raw) {
        return this.apply(raw, this.apply$default$2());
    }

    public Pattern ansiRegex() {
        return ansiRegex;
    }

    public Str apply(CharSequence raw, ErrorMode errorMode) {
        char[] chars = new char[raw.length()];
        long[] colors = new long[raw.length()];
        long currentColor = 0L;
        IntRef sourceIndex = IntRef.create((int)0);
        int destIndex = 0;
        int length = raw.length();
        while (sourceIndex.elem < length) {
            int n;
            char c = raw.charAt(sourceIndex.elem);
            if (c == '\u001b' || c == '\u009b') {
                int escapeStartSourceIndex = sourceIndex.elem;
                Option<Tuple2<Object, Either<Attr, ColorCategory>>> option = ParseMap.query(raw, escapeStartSourceIndex);
                if (None$.MODULE$.equals(option)) {
                    int n2;
                    sourceIndex.elem = n2 = errorMode.handle(sourceIndex.elem, raw);
                    continue;
                }
                if (option instanceof Some) {
                    Tuple2 tuple = (Tuple2)((Some)option).value();
                    Tuple2 tuple2 = tuple;
                    if (tuple2 != null) {
                        int n3 = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Either either = (Either)tuple2._2();
                        int newIndex = n3;
                        if (either instanceof Left) {
                            int n4;
                            Attr color = (Attr)((Left)either).value();
                            currentColor = color.transform(currentColor);
                            sourceIndex.elem = n4 = sourceIndex.elem + newIndex;
                            continue;
                        }
                        int newIndex2 = n3;
                        if (either instanceof Right) {
                            int n5;
                            int n6;
                            int n7;
                            int n8;
                            ColorCategory category = (ColorCategory)((Right)either).value();
                            sourceIndex.elem = n8 = sourceIndex.elem + newIndex2;
                            if (!this.isDigit$1(raw, sourceIndex.elem)) {
                                this.fail$1(raw, errorMode, sourceIndex, escapeStartSourceIndex);
                                continue;
                            }
                            int r = this.getNumber$1(raw, sourceIndex);
                            if (!this.checkChar$1(raw, sourceIndex.elem, ';') || !this.isDigit$1(raw, sourceIndex.elem + 1)) {
                                this.fail$1(raw, errorMode, sourceIndex, escapeStartSourceIndex);
                                continue;
                            }
                            sourceIndex.elem = n7 = sourceIndex.elem + 1;
                            int g = this.getNumber$1(raw, sourceIndex);
                            if (!this.checkChar$1(raw, sourceIndex.elem, ';') || !this.isDigit$1(raw, sourceIndex.elem + 1)) {
                                this.fail$1(raw, errorMode, sourceIndex, escapeStartSourceIndex);
                                continue;
                            }
                            sourceIndex.elem = n6 = sourceIndex.elem + 1;
                            int b = this.getNumber$1(raw, sourceIndex);
                            if (!this.checkChar$1(raw, sourceIndex.elem, 'm')) {
                                this.fail$1(raw, errorMode, sourceIndex, escapeStartSourceIndex);
                                continue;
                            }
                            sourceIndex.elem = n5 = sourceIndex.elem + 1;
                            if (0 > r || r >= 256 || 0 > g || g >= 256 || 0 > b || b >= 256) {
                                this.fail$1(raw, errorMode, sourceIndex, escapeStartSourceIndex);
                                continue;
                            }
                            currentColor = currentColor & (long)(~category.mask()) | (long)(273 + category.trueIndex(r, g, b) << category.offset());
                            continue;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError(option);
            }
            colors[destIndex] = currentColor;
            chars[destIndex] = c;
            sourceIndex.elem = n = sourceIndex.elem + 1;
            ++destIndex;
        }
        return this.caseapp$core$util$fansi$Str$$$apply(Arrays.copyOfRange(chars, 0, destIndex), Arrays.copyOfRange(colors, 0, destIndex));
    }

    public ErrorMode apply$default$2() {
        return ErrorMode$Throw$.MODULE$;
    }

    public Str fromArrays(char[] chars, long[] colors) {
        return new Str((char[])chars.clone(), (long[])colors.clone());
    }

    public Str join(Seq<Str> args) {
        int length = BoxesRunTime.unboxToInt((Object)args.iterator().map((Function1 & Serializable)_$1 -> _$1.length()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        char[] chars = new char[length];
        long[] colors = new long[length];
        IntRef j = IntRef.create((int)0);
        args.foreach((Function1)(JProcedure1 & Serializable)arg -> {
            for (int i = 0; i < arg.length(); ++i) {
                int n;
                chars$1[j$1.elem] = arg.getChar(i);
                colors$1[j$1.elem] = arg.getColor(i);
                j$1.elem = n = j$1.elem + 1;
            }
        });
        return this.fromArrays(chars, colors);
    }

    public Str fromProduct(Product x$0) {
        return new Str((char[])x$0.productElement(0), (long[])x$0.productElement(1));
    }

    private final boolean isDigit$1(CharSequence raw$1, int index) {
        return index < raw$1.length() && raw$1.charAt(index) >= '0' && raw$1.charAt(index) <= '9';
    }

    private final boolean checkChar$1(CharSequence raw$2, int index, char c) {
        return index < raw$2.length() && raw$2.charAt(index) == c;
    }

    private final void fail$1(CharSequence raw$3, ErrorMode errorMode$1, IntRef sourceIndex$1, int escapeStartSourceIndex$1) {
        int n;
        sourceIndex$1.elem = n = errorMode$1.handle(escapeStartSourceIndex$1, raw$3);
    }

    private final int getNumber$1(CharSequence raw$4, IntRef sourceIndex$2) {
        int value = 0;
        for (int count = 0; this.isDigit$1(raw$4, sourceIndex$2.elem) && count < 3; ++count) {
            int n;
            value = value * 10 + (raw$4.charAt(sourceIndex$2.elem) - 48);
            sourceIndex$2.elem = n = sourceIndex$2.elem + 1;
        }
        return value;
    }
}

