/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.complete;

import caseapp.core.complete.CompletionItem;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.hashing.MurmurHash3$;

public final class Zsh$
implements Serializable {
    private static final String shellName;
    private static final String id;
    public static final Zsh$ MODULE$;

    private Zsh$() {
    }

    static {
        MODULE$ = new Zsh$();
        shellName = "zsh";
        id = new StringBuilder(3).append(MODULE$.shellName()).append("-v1").toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Zsh$.class);
    }

    public String shellName() {
        return shellName;
    }

    public String id() {
        return id;
    }

    public String script(String progName) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("#compdef _").append(progName).append(" ").append(progName).append("\n       |\n       |function _").append(progName).append(" {\n       |  eval \"$(").append(progName).append(" complete ").append(this.id()).append(" $CURRENT $words[@])\"\n       |}\n       |").toString()));
    }

    private String hash(Iterator<String> content) {
        int hash = MurmurHash3$.MODULE$.arrayHash(content.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (hash < 0) {
            return BoxesRunTime.boxToInteger((int)(hash * -1)).toString();
        }
        return BoxesRunTime.boxToInteger((int)hash).toString();
    }

    private String escape(String input) {
        return (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.replace("'", "\\'").replace("`", "\\`").replace("|", "\\|"))).take(1).toList().headOption().getOrElse(this::escape$$anonfun$1);
    }

    private Seq<String> defs(CompletionItem item) {
        Nil$ nil$;
        Nil$ optionsOutput;
        Nil$ nil$2;
        Tuple2 tuple2 = item.values().partition((Function1 & Serializable)_$1 -> _$1.startsWith("-"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq options = (Seq)tuple2._1();
        Seq arguments = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)options, (Object)arguments);
        Seq options2 = (Seq)tuple22._1();
        Seq arguments2 = (Seq)tuple22._2();
        if (options2.isEmpty()) {
            nil$2 = package$.MODULE$.Nil();
        } else {
            Seq escapedOptions = options2;
            String desc2 = (String)item.description().map((Function1 & Serializable)desc -> new StringBuilder(1).append(":").append(this.escape((String)desc)).toString()).getOrElse(this::$anonfun$3);
            nil$2 = optionsOutput = (Seq)options2.map((Function1 & Serializable)opt -> new StringBuilder(2).append("\"").append((String)opt).append(desc2).append("\"").toString());
        }
        if (arguments2.isEmpty()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            String desc3 = (String)item.description().map((Function1 & Serializable)desc -> new StringBuilder(1).append(":").append(this.escape((String)desc)).toString()).getOrElse(this::$anonfun$6);
            nil$ = (Seq)arguments2.map((Function1 & Serializable)_$2 -> new StringBuilder(2).append("'").append(_$2.replace(":", "\\:")).append(desc3).append("'").toString());
        }
        Nil$ argumentsOutput = nil$;
        return (Seq)optionsOutput.$plus$plus((IterableOnce)argumentsOutput);
    }

    private String render(Seq<String> commands) {
        if (commands.isEmpty()) {
            return new StringBuilder(6).append("_files").append(System.lineSeparator()).toString();
        }
        String id = this.hash((Iterator<String>)commands.iterator());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(97).append("local -a args").append(id).append("\n         |args").append(id).append("=(\n         |").append(commands.mkString(System.lineSeparator())).append("\n         |)\n         |_describe command args").append(id).append("\n         |").toString()));
    }

    public String print(Seq<CompletionItem> items) {
        return this.render((Seq<String>)((Seq)items.flatMap((Function1 & Serializable)_$3 -> this.defs((CompletionItem)_$3))));
    }

    private final String escape$$anonfun$1() {
        return "";
    }

    private final String $anonfun$3() {
        return "";
    }

    private final String $anonfun$6() {
        return "";
    }
}

