/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.util.fansi;

import caseapp.core.util.fansi.Attr;
import caseapp.core.util.fansi.Category;
import caseapp.core.util.fansi.EscapeAttr;
import java.io.Serializable;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import sourcecode.Name;
import sourcecode.Name$;

public abstract class ColorCategory
extends Category {
    private final int offset;
    private final int colorCode;
    private final IndexedSeq Full;

    public ColorCategory(int offset, int width, int colorCode, Name catName) {
        this.offset = offset;
        this.colorCode = colorCode;
        super(offset, width, catName);
        this.Full = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 256).map((Function1 & Serializable)x -> this.$init$$$anonfun$6(colorCode, BoxesRunTime.unboxToInt((Object)x)));
    }

    public int colorCode() {
        return this.colorCode;
    }

    public IndexedSeq<EscapeAttr> Full() {
        return this.Full;
    }

    private EscapeAttr True0(int r, int g, int b, int index) {
        return this.makeAttr(this.trueRgbEscape(r, g, b), Int$.MODULE$.int2long(273 + index), (Name)Name$.MODULE$.wrap((Object)new StringBuilder(8).append("True(").append(r).append(",").append(g).append(",").append(b).append(")").toString()));
    }

    public String trueRgbEscape(int r, int g, int b) {
        return new StringBuilder(8).append("\u001b[").append(this.colorCode()).append(";2;").append(r).append(";").append(g).append(";").append(b).append("m").toString();
    }

    public EscapeAttr True(int index) {
        Predef$.MODULE$.require(0 <= index && index <= 0x1000000, () -> ColorCategory.True$$anonfun$1(index));
        int r = index >> 16;
        int g = (index & 0xFF00) >> 8;
        int b = index & 0xFF;
        return this.True0(r, g, b, index);
    }

    public EscapeAttr True(int r, int g, int b) {
        return this.True0(r, g, b, this.trueIndex(r, g, b));
    }

    public int trueIndex(int r, int g, int b) {
        Predef$.MODULE$.require(0 <= r && r < 256, () -> ColorCategory.trueIndex$$anonfun$1(r));
        Predef$.MODULE$.require(0 <= g && g < 256, () -> ColorCategory.trueIndex$$anonfun$2(g));
        Predef$.MODULE$.require(0 <= b && b < 256, () -> ColorCategory.trueIndex$$anonfun$3(b));
        return r << 16 | g << 8 | b;
    }

    @Override
    public String lookupEscape(long applyState) {
        int rawIndex = (int)(applyState >> this.offset);
        if (rawIndex < 273) {
            return super.lookupEscape(applyState);
        }
        int index = rawIndex - 273;
        return this.trueRgbEscape(index >> 16, (index & 0xFF00) >> 8, index & 0xFF);
    }

    @Override
    public Attr lookupAttr(long applyState) {
        int index = (int)(applyState >> this.offset);
        if (index < 273) {
            return this.lookupAttrTable()[index];
        }
        return this.True(index - 273);
    }

    @Override
    public int lookupTableWidth() {
        return 273;
    }

    private final /* synthetic */ EscapeAttr $init$$$anonfun$6(int colorCode$1, int x) {
        return this.makeAttr(new StringBuilder(6).append("\u001b[").append(colorCode$1).append(";5;").append(x).append("m").toString(), Int$.MODULE$.int2long(17 + x), (Name)Name$.MODULE$.wrap((Object)new StringBuilder(6).append("Full(").append(x).append(")").toString()));
    }

    private static final Object True$$anonfun$1(int index$3) {
        return new StringBuilder(61).append("True parameter `index` must be 273 <= index <= 16777488, not ").append(index$3).toString();
    }

    private static final Object trueIndex$$anonfun$1(int r$1) {
        return new StringBuilder(45).append("True parameter `r` must be 0 <= r < 256, not ").append(r$1).toString();
    }

    private static final Object trueIndex$$anonfun$2(int g$1) {
        return new StringBuilder(45).append("True parameter `g` must be 0 <= r < 256, not ").append(g$1).toString();
    }

    private static final Object trueIndex$$anonfun$3(int b$1) {
        return new StringBuilder(45).append("True parameter `b` must be 0 <= r < 256, not ").append(b$1).toString();
    }
}

