/*
 * Decompiled with CFR 0.152.
 */
package caseapp.core.util.fansi;

import caseapp.core.util.fansi.Attr;
import caseapp.core.util.fansi.Attr$;
import caseapp.core.util.fansi.Back$;
import caseapp.core.util.fansi.Color$;
import caseapp.core.util.fansi.ColorCategory;
import caseapp.core.util.fansi.ErrorMode;
import caseapp.core.util.fansi.ErrorMode$Throw$;
import caseapp.core.util.fansi.Str;
import caseapp.core.util.fansi.Trie;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Str$
implements Mirror.Product,
Serializable {
    private static final Pattern ansiRegex;
    private static final Trie<Either<Attr, ColorCategory>> ParseMap;
    public static final Str$ MODULE$;

    private Str$() {
    }

    static {
        MODULE$ = new Str$();
        ansiRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\u009b|\u001b\\[)[0-?]*[ -\\/]*[@-~]")).pattern();
        Vector pairs = (Vector)Attr$.MODULE$.categories().flatMap((Function1 & Serializable)cat -> (IterableOnce)cat.all().flatMap((Function1 & Serializable)color -> color.escapeOpt().map((Function1 & Serializable)str -> Tuple2$.MODULE$.apply(str, (Object)package$.MODULE$.Left().apply(color)))));
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[0m");
        Seq reset = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.Left().apply((Object)Attr$.MODULE$.Reset())), (List)Nil$.MODULE$));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[38;2;");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u001b[48;2;");
        Seq trueColors = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package$.MODULE$.Right().apply((Object)Color$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)package$.MODULE$.Right().apply((Object)Back$.MODULE$)), (List)Nil$.MODULE$)));
        ParseMap = new Trie((Seq)((IterableOps)pairs.$plus$plus((IterableOnce)reset)).$plus$plus((IterableOnce)trueColors));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Str$.class);
    }

    public Str caseapp$core$util$fansi$Str$$$apply(char[] chars, long[] colors) {
        return new Str(chars, colors);
    }

    public Str unapply(Str x$1) {
        return x$1;
    }

    public Str implicitApply(CharSequence raw) {
        return this.apply(raw, this.apply$default$2());
    }

    public Pattern ansiRegex() {
        return ansiRegex;
    }

    public Str apply(CharSequence raw, ErrorMode errorMode) {
        char[] chars = new char[raw.length()];
        long[] colors = new long[raw.length()];
        long currentColor = 0L;
        IntRef sourceIndex = IntRef.create((int)0);
        int destIndex = 0;
        int length = raw.length();
        while (sourceIndex.elem < length) {
            char c = raw.charAt(sourceIndex.elem);
            if (c == '\u001b' || c == '\u009b') {
                int escapeStartSourceIndex = sourceIndex.elem;
                Option<Tuple2<Object, Either<Attr, ColorCategory>>> option = ParseMap.query(raw, escapeStartSourceIndex);
                if (None$.MODULE$.equals(option)) {
                    sourceIndex.elem = errorMode.handle(sourceIndex.elem, raw);
                    continue;
                }
                if (option instanceof Some) {
                    Tuple2 tuple = (Tuple2)((Some)option).value();
                    Tuple2 tuple2 = tuple;
                    if (tuple2 != null) {
                        int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Either either = (Either)tuple2._2();
                        int newIndex = n;
                        if (either instanceof Left) {
                            Attr color = (Attr)((Left)either).value();
                            currentColor = color.transform(currentColor);
                            sourceIndex.elem += newIndex;
                            continue;
                        }
                        int newIndex2 = n;
                        if (either instanceof Right) {
                            ColorCategory category = (ColorCategory)((Right)either).value();
                            sourceIndex.elem += newIndex2;
                            if (!this.isDigit$1(raw, sourceIndex.elem)) {
                                this.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            int r = this.getNumber$1(sourceIndex, raw);
                            if (!this.checkChar$1(raw, sourceIndex.elem, ';') || !this.isDigit$1(raw, sourceIndex.elem + 1)) {
                                this.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            int g = this.getNumber$1(sourceIndex, raw);
                            if (!this.checkChar$1(raw, sourceIndex.elem, ';') || !this.isDigit$1(raw, sourceIndex.elem + 1)) {
                                this.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            int b = this.getNumber$1(sourceIndex, raw);
                            if (!this.checkChar$1(raw, sourceIndex.elem, 'm')) {
                                this.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            ++sourceIndex.elem;
                            if (0 > r || r >= 256 || 0 > g || g >= 256 || 0 > b || b >= 256) {
                                this.fail$1(sourceIndex, errorMode, escapeStartSourceIndex, raw);
                                continue;
                            }
                            currentColor = currentColor & (long)(~category.mask()) | (long)(273 + category.trueIndex(r, g, b) << category.offset());
                            continue;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError(option);
            }
            colors[destIndex] = currentColor;
            chars[destIndex] = c;
            ++sourceIndex.elem;
            ++destIndex;
        }
        return this.caseapp$core$util$fansi$Str$$$apply(Arrays.copyOfRange(chars, 0, destIndex), Arrays.copyOfRange(colors, 0, destIndex));
    }

    public ErrorMode apply$default$2() {
        return ErrorMode$Throw$.MODULE$;
    }

    public Str fromArrays(char[] chars, long[] colors) {
        return new Str((char[])chars.clone(), (long[])colors.clone());
    }

    public Str join(Seq<Str> args) {
        int length = BoxesRunTime.unboxToInt((Object)args.iterator().map((Function1 & Serializable)_$1 -> _$1.length()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        char[] chars = new char[length];
        long[] colors = new long[length];
        IntRef j = IntRef.create((int)0);
        args.foreach((Function1)(JProcedure1 & Serializable)arg -> {
            int i = 0;
            while (i < arg.length()) {
                chars$1[j$1.elem] = arg.getChar(i);
                colors$1[j$1.elem] = arg.getColor(i);
                ++i;
                ++j$1.elem;
            }
        });
        return this.fromArrays(chars, colors);
    }

    public Str fromProduct(Product x$0) {
        return new Str((char[])x$0.productElement(0), (long[])x$0.productElement(1));
    }

    private final boolean isDigit$1(CharSequence raw$1, int index) {
        return index < raw$1.length() && raw$1.charAt(index) >= '0' && raw$1.charAt(index) <= '9';
    }

    private final boolean checkChar$1(CharSequence raw$2, int index, char c) {
        return index < raw$2.length() && raw$2.charAt(index) == c;
    }

    private final void fail$1(IntRef sourceIndex$1, ErrorMode errorMode$1, int escapeStartSourceIndex$1, CharSequence raw$3) {
        sourceIndex$1.elem = errorMode$1.handle(escapeStartSourceIndex$1, raw$3);
    }

    private final int getNumber$1(IntRef sourceIndex$2, CharSequence raw$4) {
        int value = 0;
        for (int count = 0; this.isDigit$1(raw$4, sourceIndex$2.elem) && count < 3; ++count) {
            value = value * 10 + (raw$4.charAt(sourceIndex$2.elem) - 48);
            ++sourceIndex$2.elem;
        }
        return value;
    }
}

