/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.configuration;

import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.SystemPathArtifactResolver;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ChainedArtifactResolver
implements PluginArtifactResolver {
    protected List<PluginArtifactResolver> resolverChain = new LinkedList<PluginArtifactResolver>();

    public ChainedArtifactResolver() {
        this.resolverChain.add(new SystemPathArtifactResolver());
    }

    @Override
    public File resolveArtifact(String coordinates) throws ArtifactException {
        File result = null;
        for (PluginArtifactResolver resolver : this.resolverChain) {
            try {
                result = resolver.resolveArtifact(coordinates);
                if (result == null) continue;
                break;
            }
            catch (ArtifactException artifactException) {
            }
        }
        if (result == null) {
            throw new ArtifactException("Could not resolve artifact with coordinates " + coordinates);
        }
        return result;
    }

    public void addPluginArtifactResolver(PluginArtifactResolver pluginArtifactResolver) {
        Validate.notNull((Object)pluginArtifactResolver, (String)"PluginArtifactResolvers should not be null", (Object[])new Object[0]);
        this.resolverChain.add(pluginArtifactResolver);
    }
}

