/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.util;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.zeroturnaround.zip.ZipUtil;

public class ArchiveUtil {
    public static void autodetectAndExtract(File archiveFile, File targetDir) throws IOException {
        String filename = archiveFile.toString().toLowerCase(Locale.ROOT);
        if (filename.endsWith(".zip")) {
            ArchiveUtil.extractZip(archiveFile, targetDir);
        } else if (filename.endsWith(".tar.gz")) {
            ArchiveUtil.extractTarGz(archiveFile, targetDir);
        } else {
            throw new IOException("Unsupported archive format for " + archiveFile);
        }
    }

    public static void extractZip(File archiveFile, File targetDir) {
        ZipUtil.unpack((File)archiveFile, (File)targetDir);
    }

    public static void extractTarGz(File archiveFile, File targetDir) {
        TarGZipUnArchiver unArchiver = new TarGZipUnArchiver(archiveFile);
        unArchiver.setDestDirectory(targetDir);
        unArchiver.enableLogging((Logger)new ConsoleLogger(5, "console"));
        unArchiver.extract();
    }
}

