/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.util;

import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.SystemUtils;

public final class FilesystemUtil {
    private FilesystemUtil() {
    }

    public static File getBinDirectory(File base) {
        return new File(base, "/bin/");
    }

    public static File getDataDirectory(File base) {
        return new File(base, "/data/");
    }

    public static File getLogsDirectory(File base) {
        return new File(base, "/logs/");
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void copyRecursively(Path source, Path destination) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
            Set<Path> sources = FilesystemUtil.listFiles(source);
            for (Path srcFile : sources) {
                Path destFile = destination.resolve(srcFile.getFileName());
                FilesystemUtil.copyRecursively(srcFile, destFile);
            }
        } else {
            Files.copy(source, destination, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static Set<Path> listFiles(Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            Set<Path> set = stream.collect(Collectors.toSet());
            return set;
        }
    }

    public static void setScriptPermission(InstanceConfiguration config, String scriptName) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        if (VersionUtil.isEqualOrGreater_7_0_0(config.getClusterConfiguration().getVersion())) {
            return;
        }
        CommandLine command = new CommandLine("chmod").addArgument("755").addArgument(String.format("bin/%s", scriptName));
        ProcessUtil.executeScript(config, command);
        command = new CommandLine("sed").addArguments("-i''").addArgument("-e").addArgument("1s:.*:#!/usr/bin/env bash:", false).addArgument(String.format("bin/%s", scriptName));
        ProcessUtil.executeScript(config, command);
    }
}

