/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class InstanceConfiguration {
    private ClusterConfiguration clusterConfiguration;
    private int id;
    private String baseDir;
    private int httpPort;
    private int transportPort;
    private String pathData;
    private String pathLogs;
    private Map<String, String> environmentVariables;
    private Properties settings;

    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void setClusterConfiguration(ClusterConfiguration clusterConfiguration) {
        this.clusterConfiguration = clusterConfiguration;
    }

    public int getId() {
        return this.id;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getTransportPort() {
        return this.transportPort;
    }

    public String getPathData() {
        return this.pathData;
    }

    public String getPathLogs() {
        return this.pathLogs;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("baseDir", (Object)this.baseDir).append("httpPort", this.httpPort).append("transportPort", this.transportPort).append("pathData", (Object)this.pathData).append("pathLogs", (Object)this.pathLogs).append("settings", (Object)this.settings).toString();
    }

    public static class Builder {
        private ClusterConfiguration clusterConfiguration;
        private int id;
        private String baseDir;
        private int httpPort;
        private int transportPort;
        private String pathData;
        private String pathLogs;
        private Map<String, String> environmentVariables;
        private Properties settings;

        public Builder withClusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public Builder withId(int id) {
            this.id = id;
            return this;
        }

        public Builder withBaseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder withHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder withTransportPort(int transportPort) {
            this.transportPort = transportPort;
            return this;
        }

        public Builder withPathData(String pathData) {
            this.pathData = pathData;
            return this;
        }

        public Builder withPathLogs(String pathLogs) {
            this.pathLogs = pathLogs;
            return this;
        }

        public Builder withEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder withSettings(Properties settings) {
            this.settings = settings;
            return this;
        }

        public InstanceConfiguration build() {
            InstanceConfiguration config = new InstanceConfiguration();
            config.clusterConfiguration = this.clusterConfiguration;
            config.id = this.id;
            config.baseDir = this.baseDir;
            config.httpPort = this.httpPort;
            config.transportPort = this.transportPort;
            config.pathData = this.pathData;
            config.pathLogs = this.pathLogs;
            config.environmentVariables = this.environmentVariables == null ? Collections.emptyMap() : this.environmentVariables;
            config.settings = this.settings;
            return config;
        }
    }
}

