/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClient;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClientException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchCommand;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;

public class BootstrapClusterStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        if (config.getPathInitScripts().isEmpty()) {
            return;
        }
        List<String> filePaths = config.getPathInitScripts();
        for (String filePath : filePaths) {
            this.validateFile(filePath);
        }
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withInstanceConfiguration(config.getInstanceConfigurationList().get(0)).withHostname("localhost").build();){
            for (String filePath : filePaths) {
                Path path = Paths.get(filePath, new String[0]);
                if ("json".equalsIgnoreCase(FilenameUtils.getExtension((String)filePath))) {
                    this.parseJson(client, config.getLog(), path);
                    continue;
                }
                this.parseScript(client, config.getLog(), path);
            }
        }
    }

    protected void validateFile(String filePath) {
        if (!new File(filePath).isFile()) {
            throw new ElasticsearchSetupException("The provided init script path is not a valid file path: " + filePath);
        }
    }

    protected void parseJson(ElasticsearchClient client, Log log, Path path) {
        try {
            String json = new String(Files.readAllBytes(path));
            List commands = (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            commands.forEach(command -> {
                log.debug((CharSequence)String.format("Parsing command: %s", command));
                ElasticsearchCommand esCommand = this.parseMapCommand((Map<String, Object>)command);
                this.executeInitCommand(client, log, esCommand);
            });
        }
        catch (IOException e) {
            throw new ElasticsearchSetupException("Cannot read the init json file", e);
        }
    }

    protected ElasticsearchCommand parseMapCommand(Map<String, Object> command) {
        ElasticsearchCommand esCommand = new ElasticsearchCommand();
        String methodName = (String)command.get("method");
        esCommand.setRequestMethod(ElasticsearchCommand.RequestMethod.fromName(methodName));
        String path = (String)command.get("path");
        esCommand.setRelativeUrl(path);
        Object payload = command.get("payload");
        if (ElasticsearchCommand.RequestMethod.DELETE == esCommand.getRequestMethod()) {
            Validate.isTrue((payload == null ? 1 : 0) != 0, (String)"For DELETE commands the payload should be undefined", (Object[])new Object[0]);
        } else {
            try {
                esCommand.setJson(new ObjectMapper().writeValueAsString(payload));
            }
            catch (JsonProcessingException e) {
                throw new ElasticsearchSetupException("Cannot serialize the JSON payload for command '" + command + "'", e);
            }
        }
        return esCommand;
    }

    protected void parseScript(ElasticsearchClient client, Log log, Path path) {
        try (Stream<String> stream = Files.lines(path);){
            stream.forEach(command -> {
                log.debug((CharSequence)String.format("Parsing command: %s", command));
                ElasticsearchCommand esCommand = this.parseStringCommand((String)command);
                if (!esCommand.isSkip()) {
                    this.executeInitCommand(client, log, esCommand);
                }
            });
        }
        catch (IOException e) {
            throw new ElasticsearchSetupException("Cannot read the init script file", e);
        }
    }

    protected ElasticsearchCommand parseStringCommand(String command) {
        ElasticsearchCommand esCommand = new ElasticsearchCommand();
        String formattedCommand = command.trim();
        if (formattedCommand.isEmpty() || formattedCommand.charAt(0) == '#') {
            esCommand.setSkip(true);
        } else {
            int firstSeparatorIndex = formattedCommand.indexOf(58);
            int secondSeparatorIndex = formattedCommand.indexOf(58, firstSeparatorIndex + 1);
            if (firstSeparatorIndex == -1 || secondSeparatorIndex == -1) {
                throw new ElasticsearchSetupException("Command '" + command + "' in the script file is not properly formatted. The format is: REQUEST_METHOD:path:json_script. Ex: PUT:indexName/typeName/id:{\"shoe_size\":39, \"shoe_color\":\"orange\"}");
            }
            String methodName = formattedCommand.substring(0, firstSeparatorIndex).trim();
            ElasticsearchCommand.RequestMethod method = ElasticsearchCommand.RequestMethod.fromName(methodName);
            esCommand.setRequestMethod(method);
            String relativeUrl = formattedCommand.substring(firstSeparatorIndex + 1, secondSeparatorIndex).trim();
            esCommand.setRelativeUrl(relativeUrl);
            String json = formattedCommand.substring(secondSeparatorIndex + 1).trim();
            esCommand.setJson(json);
        }
        return esCommand;
    }

    protected void executeInitCommand(ElasticsearchClient client, Log log, ElasticsearchCommand command) {
        String url = "/" + command.getRelativeUrl();
        String content = command.getJson();
        try {
            switch (command.getRequestMethod()) {
                case PUT: {
                    client.put(url, content);
                    break;
                }
                case POST: {
                    client.post(url, content, String.class);
                    break;
                }
                case DELETE: {
                    client.delete(url);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported request method: %s", new Object[]{command.getRequestMethod()}));
                }
            }
        }
        catch (ElasticsearchClientException e) {
            throw new ElasticsearchSetupException(String.format("Cannot execute command %s", command), e);
        }
    }
}

