/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.PluginConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class InstallPluginsStep
implements InstanceStep {
    @Override
    public void execute(InstanceConfiguration config) {
        if (config.getClusterConfiguration().getPlugins().size() > 0) {
            if (VersionUtil.isEqualOrGreater_6_4_0(config.getClusterConfiguration().getVersion())) {
                FilesystemUtil.setScriptPermission(config, "elasticsearch-cli");
            }
            FilesystemUtil.setScriptPermission(config, "elasticsearch-plugin");
        }
        Log log = config.getClusterConfiguration().getLog();
        for (PluginConfiguration plugin : config.getClusterConfiguration().getPlugins()) {
            log.info((CharSequence)String.format("Installing plugin '%s' with options '%s'", plugin.getUri(), plugin.getEsJavaOpts()));
            HashMap<String, String> environment = new HashMap<String, String>(config.getEnvironmentVariables());
            if (StringUtils.isNotBlank((CharSequence)plugin.getEsJavaOpts())) {
                environment.put("ES_JAVA_OPTS", plugin.getEsJavaOpts());
            }
            CommandLine cmd = ProcessUtil.buildCommandLine("bin/elasticsearch-plugin").addArgument("install").addArgument("--batch").addArgument(plugin.getUri());
            ProcessUtil.executeScript(config, cmd, environment, null);
        }
    }
}

