/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ArchiveUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ResolveElasticsearchStep
implements InstanceStep {
    private final String ELASTICSEARCH_FILE_PARAM = "/%s";
    private final String ELASTICSEARCH_DOWNLOAD_URL = "https://artifacts.elastic.co/downloads/elasticsearch/%s";

    @Override
    public void execute(InstanceConfiguration config) {
        File unpackDirectory = null;
        try {
            File artifact = this.resolveArtifact(config.getClusterConfiguration());
            unpackDirectory = this.unpackToElasticsearchDirectory(artifact, config);
            this.setupElasticsearchConf(config);
            this.cleanUp(unpackDirectory, config.getClusterConfiguration());
        }
        catch (ArtifactException | IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.cleanUp(unpackDirectory, config.getClusterConfiguration());
                throw throwable;
            }
        }
    }

    private File resolveArtifact(ClusterConfiguration config) throws ArtifactException, IOException {
        String flavour = config.getFlavour();
        String version = config.getVersion();
        String artifactId = this.getArtifactId(flavour, version);
        String classifier = this.getArtifactClassifier(version);
        String type = this.getArtifactType(version);
        ElasticsearchArtifact artifactReference = new ElasticsearchArtifact(artifactId, version, classifier, type);
        config.getLog().debug((CharSequence)("Artifact ref: " + artifactReference));
        PluginArtifactResolver artifactResolver = config.getArtifactResolver();
        try {
            config.getLog().debug((CharSequence)"Resolving artifact against the local maven repo (stage 1)");
            return artifactResolver.resolveArtifact(artifactReference.getArtifactCoordinates());
        }
        catch (ArtifactException e) {
            config.getLog().debug((CharSequence)"Artifact not found; downloading and installing it");
            File tempFile = this.downloadArtifact(artifactReference, config);
            config.getLog().debug((CharSequence)("Installing " + tempFile + " in the local maven repo"));
            config.getArtifactInstaller().installArtifact(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion(), artifactReference.getClassifier(), artifactReference.getType(), tempFile);
            config.getLog().debug((CharSequence)"Resolving artifact against the local maven repo (stage 2)");
            return artifactResolver.resolveArtifact(artifactReference.getArtifactCoordinates());
        }
    }

    private String getArtifactId(String flavour, String version) {
        if (VersionUtil.isBetween_5_0_0_and_6_2_x(version)) {
            return "elasticsearch";
        }
        if (StringUtils.isEmpty((CharSequence)flavour)) {
            return "elasticsearch-oss";
        }
        if ("default".equals(flavour)) {
            return "elasticsearch";
        }
        return String.format("elasticsearch-%s", flavour);
    }

    private String getArtifactClassifier(String version) {
        if (VersionUtil.isEqualOrGreater_7_0_0(version)) {
            if (SystemUtils.IS_OS_WINDOWS) {
                return "windows-x86_64";
            }
            if (SystemUtils.IS_OS_MAC) {
                return "darwin-x86_64";
            }
            if (SystemUtils.IS_OS_LINUX) {
                return "linux-x86_64";
            }
            throw new IllegalStateException("Unknown OS, cannot determine the Elasticsearch classifier.");
        }
        return null;
    }

    private String getArtifactType(String version) {
        if (VersionUtil.isEqualOrGreater_7_0_0(version)) {
            if (SystemUtils.IS_OS_WINDOWS) {
                return "zip";
            }
            if (SystemUtils.IS_OS_MAC) {
                return "tar.gz";
            }
            if (SystemUtils.IS_OS_LINUX) {
                return "tar.gz";
            }
            throw new IllegalStateException("Unknown OS, cannot determine the Elasticsearch classifier.");
        }
        return "zip";
    }

    private File downloadArtifact(ElasticsearchArtifact artifactReference, ClusterConfiguration config) throws IOException {
        String filename = Joiner.on((String)"-").skipNulls().join((Object)artifactReference.getArtifactId(), (Object)artifactReference.getVersion(), new Object[]{artifactReference.getClassifier()}) + "." + artifactReference.getType();
        File tempFile = new File(FilesystemUtil.getTempDirectory(), filename);
        tempFile.deleteOnExit();
        FileUtils.deleteQuietly((File)tempFile);
        URL downloadUrl = new URL(StringUtils.isBlank((CharSequence)config.getDownloadUrl()) ? String.format("https://artifacts.elastic.co/downloads/elasticsearch/%s", filename) : (config.getDownloadUrl().endsWith("/%s") ? String.format(config.getDownloadUrl(), filename) : config.getDownloadUrl()));
        config.getLog().debug((CharSequence)("Downloading " + downloadUrl + " to " + tempFile));
        FileUtils.copyURLToFile((URL)downloadUrl, (File)tempFile);
        return tempFile;
    }

    private void cleanUp(File unpackDirectory, ClusterConfiguration config) {
        if (unpackDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)unpackDirectory);
            }
            catch (IOException e) {
                config.getLog().error((CharSequence)String.format("Could not delete Elasticsearch upack directory : ", unpackDirectory.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void setupElasticsearchConf(InstanceConfiguration config) throws IOException {
        String pathConf = config.getClusterConfiguration().getPathConf();
        if (pathConf != null && !pathConf.isEmpty()) {
            File baseDir = new File(config.getBaseDir());
            FileUtils.copyDirectory((File)new File(pathConf), (File)new File(baseDir, "config"));
        }
    }

    private File unpackToElasticsearchDirectory(File artifact, InstanceConfiguration config) throws IOException {
        File unpackDirectory = this.getUnpackDirectory();
        ArchiveUtil.autodetectAndExtract(artifact, unpackDirectory);
        File baseDir = new File(config.getBaseDir());
        this.moveToElasticsearchDirectory(unpackDirectory, baseDir);
        return unpackDirectory;
    }

    private void moveToElasticsearchDirectory(File src, File dest) throws IOException {
        File[] files = src.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        FilesystemUtil.copyRecursively(files[0].toPath(), dest.toPath());
    }

    protected File getUnpackDirectory() {
        File tempDir = FilesystemUtil.getTempDirectory();
        File upackDirectory = new File(tempDir, UUID.randomUUID().toString());
        upackDirectory.mkdirs();
        return upackDirectory;
    }
}

