/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import org.apache.commons.lang3.StringUtils;

public class ValidateFlavourStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        String flavour = config.getFlavour();
        String version = config.getVersion();
        config.getLog().debug((CharSequence)("Checking flavour '" + flavour + "' against version '" + version + "'"));
        if (StringUtils.isNotBlank((CharSequence)flavour) && VersionUtil.isBetween_5_0_0_and_6_2_x(version)) {
            throw new ElasticsearchSetupException(String.format("The flavour property is not supported for Elasticsearch [5.0.0 - 6.3.0).", new Object[0]));
        }
    }
}

