/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact.ElasticsearchArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ArchiveUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ResolveElasticsearchStep
implements InstanceStep {
    @Override
    public void execute(InstanceConfiguration config) {
        File unpackDirectory = null;
        try {
            File artifact = new ElasticsearchArtifactResolver(config.getClusterConfiguration()).resolve();
            unpackDirectory = this.unpackToElasticsearchDirectory(artifact, config);
            this.setupElasticsearchConf(config);
            this.cleanUp(unpackDirectory, config.getClusterConfiguration());
        }
        catch (ArtifactException | IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.cleanUp(unpackDirectory, config.getClusterConfiguration());
                throw throwable;
            }
        }
    }

    private void cleanUp(File unpackDirectory, ClusterConfiguration config) {
        if (unpackDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)unpackDirectory);
            }
            catch (IOException e) {
                config.getLog().error((CharSequence)String.format("Could not delete Elasticsearch unpack directory : ", unpackDirectory.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void setupElasticsearchConf(InstanceConfiguration config) throws IOException {
        String pathConf = config.getClusterConfiguration().getPathConf();
        if (pathConf != null && !pathConf.isEmpty()) {
            File baseDir = new File(config.getBaseDir());
            FileUtils.copyDirectory((File)new File(pathConf), (File)new File(baseDir, "config"));
        }
    }

    private File unpackToElasticsearchDirectory(File artifact, InstanceConfiguration config) throws IOException {
        File unpackDirectory = this.getUnpackDirectory();
        ArchiveUtil.autodetectAndExtract(artifact, unpackDirectory);
        File baseDir = new File(config.getBaseDir());
        this.moveToElasticsearchDirectory(unpackDirectory, baseDir);
        return unpackDirectory;
    }

    private void moveToElasticsearchDirectory(File src, File dest) throws IOException {
        File[] files = src.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        FilesystemUtil.copyRecursively(files[0].toPath(), dest.toPath());
    }

    protected File getUnpackDirectory() {
        File tempDir = FilesystemUtil.getTempDirectory();
        File upackDirectory = new File(tempDir, UUID.randomUUID().toString());
        upackDirectory.mkdirs();
        return upackDirectory;
    }
}

