/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class ValidateUniquePortsStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        ArrayList httpPorts = new ArrayList();
        ArrayList transportPorts = new ArrayList();
        config.getInstanceConfigurationList().forEach(instanceConfig -> {
            httpPorts.add(instanceConfig.getHttpPort());
            transportPorts.add(instanceConfig.getTransportPort());
        });
        HashSet httpPortsSet = new HashSet(httpPorts);
        HashSet transportPortsSet = new HashSet(transportPorts);
        HashSet intersection = new HashSet(httpPortsSet);
        intersection.retainAll(transportPortsSet);
        if (httpPortsSet.size() != httpPorts.size() || transportPortsSet.size() != transportPorts.size() || intersection.size() > 0) {
            throw new ElasticsearchSetupException("We have conflicting ports in the list of HTTP ports [" + StringUtils.join(httpPorts, (char)',') + "] and the list of transport ports [" + StringUtils.join(transportPorts, (char)',') + "]");
        }
    }
}

