/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class ElasticsearchArtifactResolverSlave {
    private final ClusterConfiguration config;

    public ElasticsearchArtifactResolverSlave(ClusterConfiguration config) {
        this.config = config;
    }

    public int readPort(File lockFile) throws ConditionTimeoutException {
        this.config.getLog().info((CharSequence)"Waiting for the master process to start its server");
        MutableInt serverPort = new MutableInt(0);
        try {
            Awaitility.await((String)"server port in the lock file").atMost(15L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                if (lockFile.exists()) {
                    String content = null;
                    try {
                        content = FileUtils.readFileToString((File)lockFile, (Charset)Charset.defaultCharset());
                        if (StringUtils.isNotBlank((CharSequence)content)) {
                            serverPort.setValue(Integer.parseInt(content.trim()));
                        }
                    }
                    catch (IOException e1) {
                        this.config.getLog().debug((CharSequence)"Failed to read the content of the lock file; this is unexpected, but lets not error out");
                    }
                    catch (NumberFormatException e2) {
                        this.config.getLog().debug((CharSequence)("Failed to parse the file content '" + content + "' as integer"));
                    }
                } else {
                    this.config.getLog().debug((CharSequence)"The lock file disappeared; stop trying to read the port");
                    serverPort.setValue(-1);
                }
                return serverPort.getValue() != 0;
            });
            this.config.getLog().info((CharSequence)("The master process is running its server on port " + serverPort));
            return serverPort.getValue();
        }
        catch (ConditionTimeoutException ex) {
            this.config.getLog().info((CharSequence)("We have timed out waiting for the master process to write the server port in the lock file '" + lockFile.getAbsolutePath() + "';"));
            throw ex;
        }
    }

    public void waitForMasterResolverServer(int serverPort) throws ConditionTimeoutException {
        this.config.getLog().info((CharSequence)"Waiting for the master process to finish downloading and installing");
        try {
            Awaitility.await((String)"download of Elasticsearch bundle by another plugin").atMost(10L, TimeUnit.MINUTES).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                Socket socket = null;
                try {
                    socket = new Socket(InetAddress.getLoopbackAddress(), serverPort);
                    this.config.getLog().debug((CharSequence)"Successfully connected to the other process; this means the download is in process, lets wait some more");
                    Boolean bl = false;
                    return bl;
                }
                catch (IOException e1) {
                    this.config.getLog().debug((CharSequence)"Cannot connect to the other process; assume the download has finished");
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            this.config.getLog().info((CharSequence)"The master process has finished downloading and installing");
        }
        catch (ConditionTimeoutException ex) {
            this.config.getLog().error((CharSequence)("We have timed out waiting for the master process to download and install the artifact; its server is still running on port " + serverPort + "; if it is stuck, please cancel it and restart this process"));
            throw ex;
        }
    }

    public void waitForLockFileCleanup(File lockFile) throws ConditionTimeoutException {
        this.config.getLog().info((CharSequence)"Waiting for the master process to clean up the lock file");
        try {
            Awaitility.await((String)"cleanup of the lock file by another plugin execution").atMost(15L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                boolean exists = lockFile.exists();
                this.config.getLog().debug((CharSequence)("Waiting for the lock file clean up; lock file exist = " + exists));
                return !exists;
            });
            this.config.getLog().info((CharSequence)"The master process has finished cleaning up the lock file");
        }
        catch (ConditionTimeoutException ex) {
            this.config.getLog().info((CharSequence)("We have timed out waiting for the master process to clean up the lock file '" + lockFile.getAbsolutePath() + "'"));
        }
    }
}

