/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.AbstractElasticsearchBaseMojo;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.MyArtifactInstaller;
import com.github.alexcojocaru.mojo.elasticsearch.v2.MyArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.PluginConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ChainedArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ElasticsearchConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactInstaller;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractElasticsearchMojo
extends AbstractElasticsearchBaseMojo
implements ElasticsearchConfiguration {
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepositories;
    @Parameter(property="es.flavour", defaultValue="")
    protected String flavour;
    @Parameter(property="es.version", defaultValue="5.0.0")
    protected String version;
    @Parameter(property="es.downloadUrl", defaultValue="")
    protected String downloadUrl;
    @Parameter(property="es.downloadUrlUsername", defaultValue="")
    protected String downloadUrlUsername;
    @Parameter(property="es.downloadUrlPassword", defaultValue="")
    protected String downloadUrlPassword;
    @Parameter(property="es.clusterName", defaultValue="test")
    protected String clusterName;
    @Parameter(property="es.httpPort", defaultValue="9200")
    protected int httpPort;
    @Parameter(property="es.transportPort", defaultValue="9300")
    protected int transportPort;
    @Parameter(property="es.pathConf")
    protected String pathConf;
    @Parameter(property="es.pathData")
    protected String pathData;
    @Parameter(property="es.pathLogs")
    protected String pathLogs;
    @Parameter
    protected ArrayList<PluginConfiguration> plugins = new ArrayList();
    @Parameter
    protected ArrayList<Properties> instanceSettings = new ArrayList();
    @Parameter(property="es.pathInitScript")
    protected String pathInitScript;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="es.keepExistingData", defaultValue="true")
    protected boolean keepExistingData;
    @Parameter(property="es.instanceStartupTimeout", defaultValue="120")
    protected int instanceStartupTimeout;
    @Parameter(property="es.clusterStartupTimeout", defaultValue="30")
    protected int clusterStartupTimeout;
    @Parameter(property="es.clientSocketTimeout", defaultValue="5000")
    protected int clientSocketTimeout;
    @Parameter(property="es.setAwait", defaultValue="false")
    protected boolean setAwait;
    @Parameter(property="es.autoCreateIndex", defaultValue="true")
    protected boolean autoCreateIndex;

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public RepositorySystemSession getRepositorySession() {
        return this.repositorySession;
    }

    public void setRepositorySession(RepositorySystemSession repositorySession) {
        this.repositorySession = repositorySession;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<RemoteRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    @Override
    public int getTransportPort() {
        return this.transportPort;
    }

    public void setTransportPort(int transportPort) {
        this.transportPort = transportPort;
    }

    @Override
    public String getPathConf() {
        return this.pathConf;
    }

    public void setPathConf(String pathData) {
        this.pathConf = pathData;
    }

    @Override
    public String getPathData() {
        return this.pathData;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    @Override
    public String getPathLogs() {
        return this.pathLogs;
    }

    public void setPathLogs(String pathLogs) {
        this.pathLogs = pathLogs;
    }

    public ArrayList<PluginConfiguration> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(ArrayList<PluginConfiguration> plugins) {
        this.plugins = plugins;
    }

    @Override
    public List<String> getPathInitScript() {
        if (StringUtils.isNotBlank((CharSequence)this.pathInitScript)) {
            return Stream.of(this.pathInitScript.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public void setPathInitScript(String pathInitScript) {
        this.pathInitScript = pathInitScript;
    }

    @Override
    public boolean isKeepExistingData() {
        return this.keepExistingData;
    }

    public void setKeepExistingData(boolean keepExistingData) {
        this.keepExistingData = keepExistingData;
    }

    @Override
    public int getInstanceStartupTimeout() {
        return this.instanceStartupTimeout;
    }

    public void setInstanceStartupTimeout(int instanceStartupTimeout) {
        this.instanceStartupTimeout = instanceStartupTimeout;
    }

    @Override
    public int getClusterStartupTimeout() {
        return this.clusterStartupTimeout;
    }

    public void setClusterStartupTimeout(int clusterStartupTimeout) {
        this.clusterStartupTimeout = clusterStartupTimeout;
    }

    public int getClientSocketTimeout() {
        return this.clientSocketTimeout;
    }

    public void setClientSocketTimeout(int clientSocketTimeout) {
        this.clientSocketTimeout = clientSocketTimeout;
    }

    @Override
    public boolean isSetAwait() {
        return this.setAwait;
    }

    public void setSetAwait(boolean setAwait) {
        this.setAwait = setAwait;
    }

    @Override
    public boolean isAutoCreateIndex() {
        return this.autoCreateIndex;
    }

    public void setAutoCreateIndex(boolean autoCreateIndex) {
        this.autoCreateIndex = autoCreateIndex;
    }

    @Override
    public ClusterConfiguration buildClusterConfiguration() {
        Preconditions.checkState((this.downloadUrlUsername == null == (this.downloadUrlPassword == null) ? 1 : 0) != 0, (Object)"both username and password must be supplied");
        ClusterConfiguration.Builder clusterConfigBuilder = new ClusterConfiguration.Builder().withArtifactResolver(this.buildArtifactResolver()).withArtifactInstaller(this.buildArtifactInstaller()).withLog(this.getLog()).withFlavour(this.flavour).withVersion(this.version).withDownloadUrl(this.downloadUrl).withDownloadUrlUsername(this.downloadUrlUsername).withDownloadUrlPassword(this.downloadUrlPassword).withClusterName(this.clusterName).withPathConf(this.pathConf).withElasticsearchPlugins(this.plugins).withPathInitScripts(this.getPathInitScript()).withKeepExistingData(this.keepExistingData).withStartupTimeout(this.clusterStartupTimeout).withSetAwait(this.setAwait).withAutoCreateIndex(this.autoCreateIndex);
        for (int i = 0; i < this.instanceCount; ++i) {
            Properties settings = this.instanceSettings.size() > i ? this.instanceSettings.get(i) : null;
            clusterConfigBuilder.addInstanceConfiguration(new InstanceConfiguration.Builder().withId(i).withBaseDir(this.baseDir.getAbsolutePath() + i).withHttpPort(this.httpPort + i).withTransportPort(this.transportPort + i).withPathData(this.pathData).withPathLogs(this.pathLogs).withEnvironmentVariables(this.environmentVariables).withSettings(settings).withStartupTimeout(this.instanceStartupTimeout).build());
        }
        ClusterConfiguration clusterConfig = clusterConfigBuilder.build();
        return clusterConfig;
    }

    @Override
    public PluginArtifactResolver buildArtifactResolver() {
        ChainedArtifactResolver artifactResolver = new ChainedArtifactResolver();
        artifactResolver.addPluginArtifactResolver(new MyArtifactResolver(this.repositorySystem, this.repositorySession, this.remoteRepositories, this.getLog()));
        return artifactResolver;
    }

    public PluginArtifactInstaller buildArtifactInstaller() {
        return new MyArtifactInstaller(this.repositorySystem, this.repositorySession, this.getLog());
    }
}

