/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.logging.Log;

public class ForkedElasticsearchProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final Log log;
    private final InstanceConfiguration config;
    private Process process;

    public ForkedElasticsearchProcessDestroyer(InstanceConfiguration config) {
        this.log = config.getClusterConfiguration().getLog();
        this.config = config;
    }

    public synchronized boolean add(Process process) {
        if (this.process != null) {
            throw new IllegalStateException("A process was already added; this Elasticsearch process destroyer does not support multiple processes");
        }
        this.process = process;
        return true;
    }

    public synchronized boolean remove(Process process) {
        if (this.process != process) {
            throw new IllegalStateException("Can only remove the same process that was added; this Elasticsearch process destroyer does not support multiple processes");
        }
        return true;
    }

    public int size() {
        return this.process != null && this.process.isAlive() ? 1 : 0;
    }

    @Override
    public void run() {
        if (this.process != null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.terminateWindowsProcess();
            } else {
                this.terminateUnixProcess();
            }
            this.process = null;
        }
    }

    private void terminateWindowsProcess() {
        boolean isAlive;
        String pid;
        this.log.info((CharSequence)"Cleaning up at application shutdown...");
        try {
            pid = ProcessUtil.getElasticsearchPid(this.config.getBaseDir());
            this.log.debug((CharSequence)("Read PID '" + pid + "' from pid file"));
        }
        catch (Exception ex) {
            this.log.debug((CharSequence)"Cannot read the PID from file; assuming the process is not running", (Throwable)ex);
            return;
        }
        try {
            isAlive = ProcessUtil.isWindowsProcessAlive(this.config, pid);
            this.log.debug((CharSequence)("Process is still running: " + isAlive));
        }
        catch (Exception ex) {
            this.log.debug((CharSequence)"Cannot determine if the process is running; assuming it is", (Throwable)ex);
            isAlive = true;
        }
        if (!isAlive) {
            return;
        }
        this.log.info((CharSequence)String.format("The Elasticsearch process [%d] is still running; stopping it...", this.config.getId()));
        CommandLine command = ProcessUtil.buildKillCommandLine(pid);
        for (int retry = 0; retry < 3; ++retry) {
            try {
                ProcessUtil.executeScript(this.config, command, true);
                this.log.info((CharSequence)String.format("... the Elasticsearch process [%d] has stopped.", this.config.getId()));
                ProcessUtil.cleanupPid(this.config.getBaseDir());
                break;
            }
            catch (Exception e) {
                if (e.getMessage().contains("no running instance")) {
                    this.log.info((CharSequence)String.format("... the Elasticsearch process [%d] has stopped.", this.config.getId()));
                    ProcessUtil.cleanupPid(this.config.getBaseDir());
                    break;
                }
                if (retry < 2) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.log.error((CharSequence)String.format("Error while destroying the Elasticsearch process [%d]", this.config.getId()), (Throwable)e);
                break;
            }
        }
    }

    private void terminateUnixProcess() {
        this.log.info((CharSequence)"Cleaning up at application shutdown...");
        if (this.process.isAlive()) {
            this.log.info((CharSequence)"The Elasticsearch process is still running; stopping it ...");
            this.process.destroy();
            try {
                int exitCode = this.process.waitFor();
                this.log.info((CharSequence)String.format("... the Elasticsearch process [%d] has stopped. Exit code: %d", this.config.getId(), exitCode));
            }
            catch (InterruptedException e) {
                this.log.error((CharSequence)String.format("Error while waiting for the Elasticsearch process [%d] to be destroyed", this.config.getId()), (Throwable)e);
            }
        } else {
            this.log.info((CharSequence)"The Elasticsearch process has already stopped. Nothing to clean up");
        }
    }
}

