/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.configuration;

import com.github.alexcojocaru.mojo.elasticsearch.v2.AbstractArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.InvalidCoordinatesException;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public final class Artifacts {
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;

    private Artifacts() {
    }

    public static AbstractArtifact fromCoordinates(String coordinates) {
        Iterable splitted = Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)coordinates);
        String[] strings = (String[])Iterables.toArray((Iterable)splitted, String.class);
        if (strings.length < 3 || strings.length > 5) {
            throw new InvalidCoordinatesException(coordinates);
        }
        String extension = "jar";
        String classifier = null;
        String groupId = strings[0];
        String artifactId = strings[1];
        String version = strings[strings.length - 1];
        if (strings.length == 4) {
            extension = strings[2];
        }
        if (strings.length == 5) {
            classifier = strings[3];
        }
        return new DefaultArtifact(groupId, artifactId, version, classifier, extension);
    }

    static final class DefaultArtifact
    extends AbstractArtifact {
        private String type;

        DefaultArtifact(String groupId, String artifactId, String version, String classifier, String type) {
            super(groupId, artifactId, version, classifier, type);
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }
}

