/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ElasticsearchArtifactResolverMaster {
    private final String ELASTICSEARCH_FILE_PARAM = "/%s";
    private final String ELASTICSEARCH_DOWNLOAD_URL = "https://artifacts.elastic.co/downloads/elasticsearch/%s";
    private final ClusterConfiguration config;
    private final ElasticsearchArtifact artifactReference;

    public ElasticsearchArtifactResolverMaster(ClusterConfiguration config, ElasticsearchArtifact artifactReference) {
        this.config = config;
        this.artifactReference = artifactReference;
    }

    public void resolve(File lockFile) throws ArtifactException, IOException {
        try (AsynchronousServerSocketChannel listener = AsynchronousServerSocketChannel.open().bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));){
            InetSocketAddress address = (InetSocketAddress)listener.getLocalAddress();
            this.config.getLog().debug((CharSequence)("Using port " + address.getPort() + " for the local server"));
            FileUtils.writeStringToFile((File)lockFile, (String)String.valueOf(address.getPort()), (Charset)Charset.defaultCharset());
            this.config.getLog().debug((CharSequence)("Wrote port " + address.getPort() + " to the lock file"));
            listener.accept(null, this.createServerHandler(listener));
            this.config.getLog().debug((CharSequence)("Started the server on port " + address.getPort()));
            File tempFile = this.downloadArtifact();
            this.config.getArtifactInstaller().installArtifact(this.artifactReference, tempFile);
        }
    }

    private CompletionHandler<AsynchronousSocketChannel, Void> createServerHandler(final AsynchronousServerSocketChannel listener) {
        return new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel client, Void attachment) {
                ElasticsearchArtifactResolverMaster.this.config.getLog().debug((CharSequence)"New connection created");
                if (listener.isOpen()) {
                    listener.accept(null, this);
                }
                if (client != null && client.isOpen()) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        ElasticsearchArtifactResolverMaster.this.config.getLog().warn((CharSequence)"Failed to close the socket channel", (Throwable)e);
                    }
                    ElasticsearchArtifactResolverMaster.this.config.getLog().debug((CharSequence)"New connection closed");
                } else {
                    ElasticsearchArtifactResolverMaster.this.config.getLog().debug((CharSequence)"New connection is null or already closed");
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
            }
        };
    }

    private File downloadArtifact() throws IOException {
        this.config.getLog().debug((CharSequence)"Downloading the ES artifact");
        String filename = this.artifactReference.buildBundleFilename();
        File tempFile = new File(FilesystemUtil.getTempDirectory(), filename);
        tempFile.deleteOnExit();
        FileUtils.deleteQuietly((File)tempFile);
        URL downloadUrl = new URL(StringUtils.isBlank((CharSequence)this.config.getDownloadUrl()) ? String.format("https://artifacts.elastic.co/downloads/elasticsearch/%s", filename) : (this.config.getDownloadUrl().endsWith("/%s") ? String.format(this.config.getDownloadUrl(), filename) : this.config.getDownloadUrl()));
        this.config.getLog().info((CharSequence)("Downloading " + downloadUrl + " to " + tempFile));
        URLConnection connection = downloadUrl.openConnection();
        Optional.ofNullable(this.config.getDownloadUrlUsername()).ifPresent(username -> {
            String basicAuthenticationEncoded = Base64.getEncoder().encodeToString((this.config.getDownloadUrlUsername() + ":" + this.config.getDownloadUrlPassword()).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + basicAuthenticationEncoded);
        });
        try (FileOutputStream out = FileUtils.openOutputStream((File)tempFile);){
            IOUtils.copyLarge((InputStream)connection.getInputStream(), (OutputStream)out);
        }
        return tempFile;
    }
}

