/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClient;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClientException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;

public class DisableIndexReplicationStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        if (config.getInstanceConfigurationList().size() != 1) {
            return;
        }
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withInstanceConfiguration(config.getInstanceConfigurationList().get(0)).withHostname("localhost").build();){
            if (VersionUtil.isEqualOrGreater_8_0_0(config.getVersion())) {
                String content = "{ \"index_patterns\" : [\"*\"], \"priority\" : 2147483520, \"template\": { \"settings\" : { \"number_of_replicas\": 0 } } }";
                client.put("/_index_template/default_template", content);
            } else {
                String content = "{ \"template\": \"*\", \"index_patterns\": [\"*\"], \"settings\": { \"number_of_replicas\": 0 } }";
                client.put("/_template/default_template", content);
            }
        }
        catch (ElasticsearchClientException e) {
            throw new ElasticsearchSetupException("Cannot disable index replication", e);
        }
    }
}

