/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact.ElasticsearchArtifactResolverMaster;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.resolveartifact.ElasticsearchArtifactResolverSlave;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import java.io.File;
import java.io.IOException;
import org.awaitility.core.ConditionTimeoutException;

public class ElasticsearchArtifactResolver {
    private final ClusterConfiguration config;
    private final ElasticsearchArtifact artifactReference;

    public ElasticsearchArtifactResolver(ClusterConfiguration config) {
        this.config = config;
        this.artifactReference = new ElasticsearchArtifact.ElasticsearchArtifactBuilder().withClusterConfig(config).build();
        config.getLog().debug((CharSequence)("Artifact ref: " + this.artifactReference));
    }

    public File resolve() throws ArtifactException, IOException {
        return this.resolve(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File resolve(boolean retryOnFail) throws ArtifactException, IOException {
        try {
            return this.resolveMavenArtifact();
        }
        catch (ArtifactException e) {
            int serverPort;
            this.config.getLog().info((CharSequence)"Artifact not found; going the hard way (download and install)");
            File lockFile = this.buildLockFile();
            boolean lockFileCreated = lockFile.createNewFile();
            if (lockFileCreated) {
                this.config.getLog().info((CharSequence)"Running in master mode. Created the lock file.");
                lockFile.deleteOnExit();
                try {
                    new ElasticsearchArtifactResolverMaster(this.config, this.artifactReference).resolve(lockFile);
                }
                finally {
                    lockFile.delete();
                }
            }
            this.config.getLog().info((CharSequence)"Running in slave mode. The lock file already exists.");
            ElasticsearchArtifactResolverSlave resolverSlave = new ElasticsearchArtifactResolverSlave(this.config);
            try {
                serverPort = resolverSlave.readPort(lockFile);
            }
            catch (ConditionTimeoutException e1) {
                return this.cleanupLockFileAndRetry(lockFile, retryOnFail);
            }
            if (serverPort == -1) {
                this.config.getLog().info((CharSequence)"The master process has finished downloading and installing the artifact");
                return this.resolveMavenArtifact();
            }
            resolverSlave.waitForMasterResolverServer(serverPort);
            try {
                resolverSlave.waitForLockFileCleanup(lockFile);
            }
            catch (ConditionTimeoutException ex) {
                return this.cleanupLockFileAndRetry(lockFile, retryOnFail);
            }
            return this.resolveMavenArtifact();
        }
    }

    private File buildLockFile() {
        String esFilename = this.artifactReference.buildBundleFilename();
        String lockFilename = "elasticsearch-maven-plugin_" + esFilename + ".lock";
        File lockFile = new File(FilesystemUtil.getTempDirectory(), lockFilename);
        this.config.getLog().debug((CharSequence)("Using lock file '" + lockFile.getAbsolutePath() + "'"));
        return lockFile;
    }

    private File cleanupLockFileAndRetry(File lockFile, boolean retryOnFail) throws ArtifactException, IOException {
        this.config.getLog().info((CharSequence)"Presume that the lock file was left over; delete it and retry");
        if (!lockFile.delete()) {
            throw new RuntimeException("The lock file '" + lockFile.getAbsolutePath() + "' doesn't seem to be in use, yet we failed to remove it");
        }
        if (retryOnFail) {
            return this.resolve(false);
        }
        throw new RuntimeException("The final attempt to resolve the Elasticsearch artifact has failed");
    }

    private File resolveMavenArtifact() throws ArtifactException {
        this.config.getLog().debug((CharSequence)"Resolving artifact against the local maven repo");
        return this.config.getArtifactResolver().resolveArtifact(this.artifactReference.getArtifactCoordinates());
    }
}

