/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.PluginConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactInstaller;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.maven.plugin.logging.Log;

public class ClusterConfiguration {
    private List<InstanceConfiguration> instanceConfigurationList;
    private PluginArtifactResolver artifactResolver;
    private PluginArtifactInstaller artifactInstaller;
    private Log log;
    private String flavour;
    private String version;
    private String downloadUrl;
    private String downloadUrlUsername;
    private String downloadUrlPassword;
    private String clusterName;
    private String pathConf;
    private List<PluginConfiguration> plugins;
    private List<String> pathInitScripts;
    private boolean keepExistingData;
    private int startupTimeout;
    private int clientSocketTimeout;
    private boolean setAwait;
    private boolean autoCreateIndex;

    private ClusterConfiguration(List<InstanceConfiguration> instanceConfigurationList, PluginArtifactResolver artifactResolver, PluginArtifactInstaller artifactInstaller, Log log) {
        this.instanceConfigurationList = instanceConfigurationList;
        this.artifactResolver = artifactResolver;
        this.artifactInstaller = artifactInstaller;
        this.log = log;
    }

    public List<InstanceConfiguration> getInstanceConfigurationList() {
        return this.instanceConfigurationList;
    }

    public PluginArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public PluginArtifactInstaller getArtifactInstaller() {
        return this.artifactInstaller;
    }

    public Log getLog() {
        return this.log;
    }

    public String getFlavour() {
        return this.flavour;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getDownloadUrlUsername() {
        return this.downloadUrlUsername;
    }

    public String getDownloadUrlPassword() {
        return this.downloadUrlPassword;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPathConf() {
        return this.pathConf;
    }

    public List<PluginConfiguration> getPlugins() {
        return this.plugins;
    }

    public List<String> getPathInitScripts() {
        return this.pathInitScripts;
    }

    public boolean isKeepExistingData() {
        return this.keepExistingData;
    }

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public int getClientSocketTimeout() {
        return this.clientSocketTimeout;
    }

    public boolean isSetAwait() {
        return this.setAwait;
    }

    public boolean isAutoCreateIndex() {
        return this.autoCreateIndex;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("flavour", (Object)this.flavour).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("downloadUrlUsername", (Object)this.downloadUrlUsername).append("downloadUrlPassword", Optional.ofNullable(this.downloadUrlPassword).map(p -> "****").orElse(null)).append("clusterName", (Object)this.clusterName).append("pathConfigFile", (Object)this.pathConf).append("plugins", this.plugins).append("pathInitScripts", this.pathInitScripts).append("keepExistingData", this.keepExistingData).append("startupTimeout", this.startupTimeout).append("clientSocketTimeout", this.clientSocketTimeout).append("setAwait", this.setAwait).append("autoCreateIndex", this.autoCreateIndex).append("instanceConfigurationList", (Object)StringUtils.join(this.instanceConfigurationList, (char)',')).toString();
    }

    public static class Builder {
        private List<InstanceConfiguration> instanceConfigurationList = new ArrayList<InstanceConfiguration>();
        private PluginArtifactResolver artifactResolver;
        private PluginArtifactInstaller artifactInstaller;
        private Log log;
        private String flavour;
        private String version;
        private String downloadUrl;
        private String downloadUrlUsername;
        private String downloadUrlPassword;
        private String clusterName;
        private String pathConf;
        private List<PluginConfiguration> plugins;
        private List<String> pathInitScripts;
        private boolean keepExistingData;
        private int startupTimeout;
        private int clientSocketTimeout;
        private boolean setAwait;
        private boolean autoCreateIndex;

        public Builder addInstanceConfiguration(InstanceConfiguration config) {
            this.instanceConfigurationList.add(config);
            return this;
        }

        public Builder withArtifactResolver(PluginArtifactResolver artifactResolver) {
            this.artifactResolver = artifactResolver;
            return this;
        }

        public Builder withArtifactInstaller(PluginArtifactInstaller artifactInstaller) {
            this.artifactInstaller = artifactInstaller;
            return this;
        }

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withFlavour(String flavour) {
            this.flavour = flavour;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder withDownloadUrlUsername(String downloadUrlUsername) {
            this.downloadUrlUsername = downloadUrlUsername;
            return this;
        }

        public Builder withDownloadUrlPassword(String downloadUrlPassword) {
            this.downloadUrlPassword = downloadUrlPassword;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withPathConf(String pathConf) {
            this.pathConf = pathConf;
            return this;
        }

        public Builder withElasticsearchPlugins(List<PluginConfiguration> plugins) {
            this.plugins = plugins;
            return this;
        }

        public Builder withPathInitScripts(List<String> pathInitScripts) {
            this.pathInitScripts = pathInitScripts;
            return this;
        }

        public Builder withKeepExistingData(boolean keepExistingData) {
            this.keepExistingData = keepExistingData;
            return this;
        }

        public Builder withStartupTimeout(int startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public Builder withClientSocketTimeout(int clientSocketTimeout) {
            this.clientSocketTimeout = clientSocketTimeout;
            return this;
        }

        public Builder withSetAwait(boolean setAwait) {
            this.setAwait = setAwait;
            return this;
        }

        public Builder withAutoCreateIndex(boolean autoCreateIndex) {
            this.autoCreateIndex = autoCreateIndex;
            return this;
        }

        public ClusterConfiguration build() {
            ClusterConfiguration config = new ClusterConfiguration(this.instanceConfigurationList, this.artifactResolver, this.artifactInstaller, this.log);
            config.flavour = this.flavour;
            config.version = this.version;
            config.downloadUrl = this.downloadUrl;
            config.downloadUrlUsername = this.downloadUrlUsername;
            config.downloadUrlPassword = this.downloadUrlPassword;
            config.clusterName = this.clusterName;
            config.pathConf = this.pathConf;
            config.plugins = this.plugins;
            config.pathInitScripts = this.pathInitScripts;
            config.keepExistingData = this.keepExistingData;
            config.startupTimeout = this.startupTimeout;
            config.clientSocketTimeout = this.clientSocketTimeout;
            config.setAwait = this.setAwait;
            config.autoCreateIndex = this.autoCreateIndex;
            config.getInstanceConfigurationList().forEach(c -> c.setClusterConfiguration(config));
            return config;
        }
    }
}

