/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.AbstractArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ElasticsearchArtifact
extends AbstractArtifact {
    public static final String ELASTICSEARCH_GROUPID = "com.github.alexcojocaru";

    public ElasticsearchArtifact(String artifactId, String version, String classifier, String type) {
        super(ELASTICSEARCH_GROUPID, artifactId, version, classifier, type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String buildBundleFilename() {
        return Arrays.asList(this.getArtifactId(), this.getVersion(), this.getClassifier()).stream().filter(Objects::nonNull).collect(Collectors.joining("-")) + "." + this.getType();
    }

    @Override
    public String toString() {
        return "ElasticsearchArtifact[" + super.getArtifactCoordinates() + "]";
    }

    public static class ElasticsearchArtifactBuilder {
        private ClusterConfiguration clusterConfig;

        public ElasticsearchArtifactBuilder withClusterConfig(ClusterConfiguration clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public ElasticsearchArtifact build() {
            String flavour = this.clusterConfig.getFlavour();
            String version = this.clusterConfig.getVersion();
            String id = this.getArtifactId(flavour, version);
            String classifier = this.getArtifactClassifier(version);
            String type = this.getArtifactType(version);
            return new ElasticsearchArtifact(id, version, classifier, type);
        }

        private String getArtifactId(String flavour, String version) {
            if (VersionUtil.isBetween_6_3_0_and_7_10_x(version)) {
                if (StringUtils.isEmpty((CharSequence)flavour)) {
                    return "elasticsearch-oss";
                }
                if ("default".equals(flavour)) {
                    return "elasticsearch";
                }
                return String.format("elasticsearch-%s", flavour);
            }
            return "elasticsearch";
        }

        public static void main(String[] args) {
            System.out.println(SystemUtils.OS_ARCH);
        }

        private String getArtifactClassifier(String version) {
            if (VersionUtil.isEqualOrGreater_7_0_0(version)) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    return "windows-x86_64";
                }
                String arch = SystemUtils.OS_ARCH;
                if (arch == null) {
                    throw new IllegalStateException("Cannot determine the OS arch, thus cannot build the artifact name to download. As a workaround, you can use the 'downloadUrl' plugin property.");
                }
                if (SystemUtils.IS_OS_MAC) {
                    return "darwin-" + arch.toLowerCase();
                }
                if (SystemUtils.IS_OS_LINUX) {
                    if (arch.equalsIgnoreCase("amd64") || arch.equalsIgnoreCase("x86_64")) {
                        return "linux-x86_64";
                    }
                    if (arch.equalsIgnoreCase("aarch64")) {
                        return "linux-aarch64";
                    }
                    throw new IllegalStateException("Unknown linux OS architecture name '" + arch + "'");
                }
                throw new IllegalStateException("Unknown OS, cannot determine the Elasticsearch classifier.");
            }
            return null;
        }

        private String getArtifactType(String version) {
            if (VersionUtil.isEqualOrGreater_7_0_0(version)) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    return "zip";
                }
                if (SystemUtils.IS_OS_MAC) {
                    return "tar.gz";
                }
                if (SystemUtils.IS_OS_LINUX) {
                    return "tar.gz";
                }
                throw new IllegalStateException("Unknown OS, cannot determine the Elasticsearch classifier.");
            }
            return "zip";
        }
    }
}

