/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ForkedElasticsearchProcessDestroyer;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceSetupSequence;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceStepSequence;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;

public class ForkedInstance
implements Runnable {
    private final InstanceConfiguration config;

    public ForkedInstance(InstanceConfiguration config) {
        this.config = config;
    }

    public void configureInstance() {
        this.getSetupSequence().execute(this.config);
    }

    @Override
    public void run() {
        FilesystemUtil.setScriptPermission(this.config, "elasticsearch");
        ForkedElasticsearchProcessDestroyer processDestroyer = new ForkedElasticsearchProcessDestroyer(this.config);
        Runtime.getRuntime().addShutdownHook(new Thread(processDestroyer));
        ProcessUtil.executeScript(this.config, this.getStartScriptCommand(), this.config.getEnvironmentVariables(), processDestroyer);
    }

    private InstanceStepSequence getSetupSequence() {
        InstanceSetupSequence sequence = new InstanceSetupSequence();
        return sequence;
    }

    protected CommandLine getStartScriptCommand() {
        CommandLine cmd = ProcessUtil.buildCommandLine("bin/elasticsearch");
        cmd.addArgument("-p", false);
        cmd.addArgument("pid", false);
        cmd.addArgument("-Ecluster.name=" + this.config.getClusterConfiguration().getClusterName(), false);
        cmd.addArgument("-Ehttp.port=" + this.config.getHttpPort(), false);
        String transportPortName = VersionUtil.isEqualOrGreater_8_0_0(this.config.getClusterConfiguration().getVersion()) ? "transport.port" : "transport.tcp.port";
        cmd.addArgument("-E" + transportPortName + "=" + this.config.getTransportPort(), false);
        if (VersionUtil.isEqualOrGreater_7_0_0(this.config.getClusterConfiguration().getVersion())) {
            if (this.config.getClusterConfiguration().getInstanceConfigurationList().size() > 1) {
                String hosts = this.config.getClusterConfiguration().getInstanceConfigurationList().stream().map(config -> "127.0.0.1:" + config.getTransportPort()).collect(Collectors.joining(","));
                cmd.addArgument("-Ediscovery.seed_hosts=" + hosts, false);
                cmd.addArgument("-Ecluster.initial_master_nodes=" + hosts, false);
            } else {
                cmd.addArgument("-Ediscovery.type=single-node", false);
            }
        } else {
            String hosts = this.config.getClusterConfiguration().getInstanceConfigurationList().stream().filter(instanceConfig -> this.config != instanceConfig).map(config -> "127.0.0.1:" + config.getTransportPort()).collect(Collectors.joining(","));
            if (StringUtils.isNotEmpty((CharSequence)hosts)) {
                cmd.addArgument("-Ediscovery.zen.ping.unicast.hosts=" + hosts, false);
            }
        }
        if (!this.config.getClusterConfiguration().isAutoCreateIndex()) {
            cmd.addArgument("-Eaction.auto_create_index=false", false);
        }
        cmd.addArgument("-Ehttp.cors.enabled=true");
        if (this.config.getSettings() != null) {
            this.config.getSettings().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> cmd.addArgument("-E" + key + '=' + value)));
        }
        if (VersionUtil.isEqualOrGreater_8_0_0(this.config.getClusterConfiguration().getVersion())) {
            cmd.addArgument("-Expack.security.enabled=false", false);
        }
        return cmd;
    }
}

