/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchArtifact;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactInstaller;
import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;

public class MyArtifactInstaller
implements PluginArtifactInstaller {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySession;
    private final Log log;

    public MyArtifactInstaller(RepositorySystem repositorySystem, RepositorySystemSession repositorySession, Log log) {
        this.repositorySystem = repositorySystem;
        this.repositorySession = repositorySession;
        this.log = log;
    }

    @Override
    public void installArtifact(ElasticsearchArtifact artifact, File file) throws ArtifactException {
        this.log.debug((CharSequence)("Installing '" + file.getAbsolutePath() + "' in the local maven repo"));
        InstallRequest request = new InstallRequest();
        DefaultArtifact defaultArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), null, file);
        request.addArtifact((Artifact)defaultArtifact);
        this.log.info((CharSequence)String.format("Installing maven artifact: %s", artifact));
        try {
            this.repositorySystem.install(this.repositorySession, request);
        }
        catch (InstallationException e) {
            throw new ArtifactException(e.getMessage(), e);
        }
    }
}

