/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ArtifactException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class MyArtifactResolver
implements PluginArtifactResolver {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySession;
    private final List<RemoteRepository> remoteRepositories;
    private final Log log;

    public MyArtifactResolver(RepositorySystem repositorySystem, RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories, Log log) {
        this.repositorySystem = repositorySystem;
        this.repositorySession = repositorySession;
        this.remoteRepositories = remoteRepositories;
        this.log = log;
    }

    @Override
    public File resolveArtifact(String coordinates) throws ArtifactException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepositories);
        this.log.debug((CharSequence)String.format("Resolving artifact %s from %s", artifact, this.remoteRepositories));
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactException(e.getMessage(), e);
        }
        this.log.debug((CharSequence)String.format("Resolved artifact %s to %s from %s", artifact, result.getArtifact().getFile(), result.getRepository()));
        return result.getArtifact().getFile();
    }
}

