/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.AbstractElasticsearchBaseMojo;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import org.apache.commons.exec.CommandLine;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class StopMojo
extends AbstractElasticsearchBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        ClusterConfiguration clusterConfig = this.buildClusterConfiguration();
        for (InstanceConfiguration config : clusterConfig.getInstanceConfigurationList()) {
            try {
                this.getLog().info((CharSequence)String.format("Stopping Elasticsearch [%s]", config));
                String baseDir = config.getBaseDir();
                ProcessUtil.executeScript(config, this.getShutdownScriptCommand(baseDir));
                this.getLog().info((CharSequence)String.format("Elasticsearch [%d] stopped", config.getId()));
                ProcessUtil.cleanupPid(baseDir);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Exception while stopping Elasticsearch", (Throwable)e);
            }
        }
    }

    protected CommandLine getShutdownScriptCommand(String basePath) {
        String pid = ProcessUtil.getElasticsearchPid(basePath);
        return ProcessUtil.buildKillCommandLine(pid);
    }
}

