/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.client;

import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClient;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClientException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.awaitility.Awaitility;

public class Monitor {
    private final ElasticsearchClient client;
    private final Log log;

    public Monitor(ElasticsearchClient client, Log log) {
        this.client = client;
        this.log = log;
    }

    public void waitToStartInstance(final String baseDir, final String clusterName, int timeout) {
        this.log.debug((CharSequence)String.format("Waiting up to %ds for the Elasticsearch instance to start ...", timeout));
        Awaitility.await().atMost((long)timeout, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Monitor.isProcessRunning(Monitor.this.log, baseDir) && Monitor.this.isInstanceRunning(clusterName);
            }
        });
        this.log.info((CharSequence)"The Elasticsearch instance has started");
    }

    public static boolean isProcessRunning(Log log, String baseDir) {
        File pidFile = new File(baseDir, "pid");
        boolean exists = pidFile.isFile();
        log.debug((CharSequence)String.format("pid file exists: %s", pidFile.isFile()));
        return exists;
    }

    public boolean isInstanceRunning(String clusterName) {
        boolean result;
        try {
            Map response = this.client.get("/", Map.class);
            result = clusterName.equals(response.get("cluster_name"));
        }
        catch (ElasticsearchClientException e) {
            this.log.debug((CharSequence)"Errored out when calling '/'");
            result = false;
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Errored out while parsing the response from '/'", (Throwable)e);
            result = false;
        }
        return result;
    }

    public static boolean isInstanceRunning(Log log, String clusterName, int httpPort) {
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withLog(log).withHostname("localhost").withPort(httpPort).withSocketTimeout(5000).build();){
            boolean bl = new Monitor(client, log).isInstanceRunning(clusterName);
            return bl;
        }
    }

    public void waitToStartCluster(final String clusterName, final int nodesCount, int timeout) {
        this.log.debug((CharSequence)String.format("Waiting up to %ds for the Elasticsearch cluster to start ...", timeout));
        Awaitility.await().atMost((long)timeout, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Monitor.this.isClusterRunning(clusterName, nodesCount);
            }
        });
        this.log.info((CharSequence)"The Elasticsearch cluster has started");
    }

    public static boolean isClusterRunning(Log log, String clusterName, int instanceCount, ElasticsearchClient client) {
        return new Monitor(client, log).isClusterRunning(clusterName, instanceCount);
    }

    public static boolean isClusterRunning(Log log, String clusterName, int instanceCount, int httpPort) {
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withLog(log).withHostname("localhost").withPort(httpPort).withSocketTimeout(5000).build();){
            boolean bl = new Monitor(client, log).isClusterRunning(clusterName, instanceCount);
            return bl;
        }
    }

    private boolean isClusterRunning(String clusterName, int instanceCount) {
        boolean result = true;
        try {
            Map responseNodes = this.client.get("/_nodes", Map.class);
            result &= clusterName.equals(responseNodes.get("cluster_name"));
            Map nodesInfo = (Map)responseNodes.get("_nodes");
            result &= instanceCount == (Integer)nodesInfo.get("successful");
        }
        catch (ElasticsearchClientException e) {
            this.log.debug((CharSequence)"Errored out when calling '/_nodes'");
            result = false;
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Errored out while parsing the response from '/_nodes'", (Throwable)e);
            result = false;
        }
        try {
            Map responseHealth = this.client.get("/_cluster/health", Map.class);
            result &= (Boolean)responseHealth.get("timed_out") == false && clusterName.equals(responseHealth.get("cluster_name")) && "green".equals(responseHealth.get("status")) && instanceCount == (Integer)responseHealth.get("number_of_nodes") && 0 < (Integer)responseHealth.get("number_of_data_nodes") && 100.0 == (Double)responseHealth.get("active_shards_percent_as_number") && 0 == (Integer)responseHealth.get("number_of_pending_tasks");
        }
        catch (ElasticsearchClientException e) {
            this.log.debug((CharSequence)"Errored out when calling '/_cluster/health'");
            result = false;
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Errored out while parsing the response from '/_cluster/health'", (Throwable)e);
            result = false;
        }
        return result;
    }
}

