/*
 * Decompiled with CFR 0.152.
 */
package alex.mojaki.s3upload;

import alex.mojaki.s3upload.ClosableQueue;
import alex.mojaki.s3upload.ExecutorServiceResultsHandler;
import alex.mojaki.s3upload.IntegrityCheckException;
import alex.mojaki.s3upload.MultiPartOutputStream;
import alex.mojaki.s3upload.StreamPart;
import alex.mojaki.s3upload.Utils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.BinaryUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransferManager {
    private static final Logger log = LoggerFactory.getLogger(StreamTransferManager.class);
    protected final String bucketName;
    protected final String putKey;
    protected final AmazonS3 s3Client;
    protected String uploadId;
    protected int numStreams = 1;
    protected int numUploadThreads = 1;
    protected int queueCapacity = 1;
    protected int partSize = 0x500000;
    protected boolean checkIntegrity = false;
    private final List<PartETag> partETags = Collections.synchronizedList(new ArrayList());
    private List<MultiPartOutputStream> multiPartOutputStreams;
    private ExecutorServiceResultsHandler<Void> executorServiceResultsHandler;
    private ClosableQueue<StreamPart> queue;
    private int finishedCount = 0;
    private StreamPart leftoverStreamPart = null;
    private final Object leftoverStreamPartLock = new Object();
    private boolean isAborting = false;
    private static final int MAX_PART_NUMBER = 10000;

    public StreamTransferManager(String bucketName, String putKey, AmazonS3 s3Client) {
        this.bucketName = bucketName;
        this.putKey = putKey;
        this.s3Client = s3Client;
    }

    public StreamTransferManager numStreams(int numStreams) {
        this.ensureCanSet();
        if (numStreams < 1) {
            throw new IllegalArgumentException("There must be at least one stream");
        }
        this.numStreams = numStreams;
        return this;
    }

    public StreamTransferManager numUploadThreads(int numUploadThreads) {
        this.ensureCanSet();
        if (numUploadThreads < 1) {
            throw new IllegalArgumentException("There must be at least one upload thread");
        }
        this.numUploadThreads = numUploadThreads;
        return this;
    }

    public StreamTransferManager queueCapacity(int queueCapacity) {
        this.ensureCanSet();
        if (queueCapacity < 1) {
            throw new IllegalArgumentException("The queue capacity must be at least 1");
        }
        this.queueCapacity = queueCapacity;
        return this;
    }

    public StreamTransferManager partSize(long partSize) {
        this.ensureCanSet();
        if ((partSize *= 0x100000L) < 0x500000L) {
            throw new IllegalArgumentException(String.format("The given part size (%d) is less than 5 MB.", partSize));
        }
        if (partSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The given part size (%d) is too large as it does not fit in a 32 bit int", partSize));
        }
        this.partSize = (int)partSize;
        return this;
    }

    public StreamTransferManager checkIntegrity(boolean checkIntegrity) {
        this.ensureCanSet();
        if (checkIntegrity) {
            Utils.md5();
        }
        this.checkIntegrity = checkIntegrity;
        return this;
    }

    private void ensureCanSet() {
        if (this.queue != null) {
            this.abort();
            throw new IllegalStateException("Setters cannot be called after getMultiPartOutputStreams");
        }
    }

    @Deprecated
    public StreamTransferManager(String bucketName, String putKey, AmazonS3 s3Client, int numStreams, int numUploadThreads, int queueCapacity, int partSize) {
        this(bucketName, putKey, s3Client);
        this.numStreams(numStreams);
        this.numUploadThreads(numUploadThreads);
        this.queueCapacity(queueCapacity);
        this.partSize(partSize);
    }

    public List<MultiPartOutputStream> getMultiPartOutputStreams() {
        if (this.multiPartOutputStreams != null) {
            return this.multiPartOutputStreams;
        }
        this.queue = new ClosableQueue(this.queueCapacity);
        log.debug("Initiating multipart upload to {}/{}", (Object)this.bucketName, (Object)this.putKey);
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucketName, this.putKey);
        this.customiseInitiateRequest(initRequest);
        InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
        this.uploadId = initResponse.getUploadId();
        log.info("Initiated multipart upload to {}/{} with full ID {}", new Object[]{this.bucketName, this.putKey, this.uploadId});
        try {
            int i;
            this.multiPartOutputStreams = new ArrayList<MultiPartOutputStream>();
            ExecutorService threadPool = Executors.newFixedThreadPool(this.numUploadThreads);
            int partNumberStart = 1;
            for (i = 0; i < this.numStreams; ++i) {
                int partNumberEnd = (i + 1) * 10000 / this.numStreams + 1;
                MultiPartOutputStream multiPartOutputStream = new MultiPartOutputStream(partNumberStart, partNumberEnd, this.partSize, this.queue);
                partNumberStart = partNumberEnd;
                this.multiPartOutputStreams.add(multiPartOutputStream);
            }
            this.executorServiceResultsHandler = new ExecutorServiceResultsHandler(threadPool);
            for (i = 0; i < this.numUploadThreads; ++i) {
                this.executorServiceResultsHandler.submit(new UploadTask());
            }
            this.executorServiceResultsHandler.finishedSubmitting();
        }
        catch (Throwable e) {
            throw this.abort(e);
        }
        return this.multiPartOutputStreams;
    }

    public void complete() {
        try {
            log.debug("{}: Waiting for pool termination", (Object)this);
            this.executorServiceResultsHandler.awaitCompletion();
            log.debug("{}: Pool terminated", (Object)this);
            if (this.leftoverStreamPart != null) {
                log.info("{}: Uploading leftover stream {}", (Object)this, (Object)this.leftoverStreamPart);
                this.uploadStreamPart(this.leftoverStreamPart);
                log.debug("{}: Leftover uploaded", (Object)this);
            }
            log.debug("{}: Completing", (Object)this);
            if (this.partETags.isEmpty()) {
                log.debug("{}: Uploading empty stream", (Object)this);
                ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(0L);
                PutObjectRequest request = new PutObjectRequest(this.bucketName, this.putKey, (InputStream)emptyStream, metadata);
                this.customisePutEmptyObjectRequest(request);
                this.s3Client.putObject(request);
            } else {
                ArrayList<PartETag> sortedParts = new ArrayList<PartETag>(this.partETags);
                Collections.sort(sortedParts, new PartNumberComparator());
                CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(this.bucketName, this.putKey, this.uploadId, sortedParts);
                this.customiseCompleteRequest(completeRequest);
                CompleteMultipartUploadResult completeMultipartUploadResult = this.s3Client.completeMultipartUpload(completeRequest);
                if (this.checkIntegrity) {
                    this.checkCompleteFileIntegrity(completeMultipartUploadResult.getETag(), sortedParts);
                }
            }
            log.info("{}: Completed", (Object)this);
        }
        catch (IntegrityCheckException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.abort(e);
        }
    }

    private void checkCompleteFileIntegrity(String s3ObjectETag, List<PartETag> sortedParts) {
        String expectedETag = this.computeCompleteFileETag(sortedParts);
        if (!expectedETag.equals(s3ObjectETag)) {
            throw new IntegrityCheckException(String.format("File upload completed, but integrity check failed. Expected ETag: %s but actual is %s", expectedETag, s3ObjectETag));
        }
    }

    private String computeCompleteFileETag(List<PartETag> parts) {
        MessageDigest md = Utils.md5();
        for (PartETag partETag : parts) {
            md.update(BinaryUtils.fromHex((String)partETag.getETag()));
        }
        return String.format("%032x-%d", new BigInteger(1, md.digest()), parts.size());
    }

    public RuntimeException abort(Throwable t) {
        if (!this.isAborting) {
            log.error("Aborting {} due to error: {}", (Object)this, (Object)t.toString());
        }
        this.abort();
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof InterruptedException) {
            throw Utils.runtimeInterruptedException((InterruptedException)t);
        }
        throw new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        StreamTransferManager streamTransferManager = this;
        synchronized (streamTransferManager) {
            if (this.isAborting) {
                return;
            }
            this.isAborting = true;
        }
        if (this.executorServiceResultsHandler != null) {
            this.executorServiceResultsHandler.abort();
        }
        if (this.queue != null) {
            this.queue.close();
        }
        if (this.uploadId != null) {
            log.debug("{}: Aborting", (Object)this);
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.bucketName, this.putKey, this.uploadId);
            this.s3Client.abortMultipartUpload(abortMultipartUploadRequest);
            log.info("{}: Aborted", (Object)this);
        }
    }

    private void uploadStreamPart(StreamPart part) {
        log.debug("{}: Uploading {}", (Object)this, (Object)part);
        UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.putKey).withUploadId(this.uploadId).withPartNumber(part.getPartNumber()).withInputStream(part.getInputStream()).withPartSize(part.size());
        if (this.checkIntegrity) {
            uploadRequest.setMd5Digest(part.getMD5Digest());
        }
        this.customiseUploadPartRequest(uploadRequest);
        UploadPartResult uploadPartResult = this.s3Client.uploadPart(uploadRequest);
        PartETag partETag = uploadPartResult.getPartETag();
        this.partETags.add(partETag);
        log.info("{}: Finished uploading {}", (Object)this, (Object)part);
    }

    public String toString() {
        return String.format("[Manager uploading to %s/%s with id %s]", this.bucketName, this.putKey, Utils.skipMiddle(this.uploadId, 21));
    }

    public void customiseInitiateRequest(InitiateMultipartUploadRequest request) {
    }

    public void customiseUploadPartRequest(UploadPartRequest request) {
    }

    public void customiseCompleteRequest(CompleteMultipartUploadRequest request) {
    }

    public void customisePutEmptyObjectRequest(PutObjectRequest request) {
    }

    private static class PartNumberComparator
    implements Comparator<PartETag> {
        private PartNumberComparator() {
        }

        @Override
        public int compare(PartETag o1, PartETag o2) {
            int partNumber2;
            int partNumber1 = o1.getPartNumber();
            if (partNumber1 == (partNumber2 = o2.getPartNumber())) {
                return 0;
            }
            return partNumber1 > partNumber2 ? 1 : -1;
        }
    }

    private class UploadTask
    implements Callable<Void> {
        private UploadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                while (true) {
                    StreamPart part;
                    ClosableQueue closableQueue = StreamTransferManager.this.queue;
                    synchronized (closableQueue) {
                        if (StreamTransferManager.this.finishedCount < StreamTransferManager.this.multiPartOutputStreams.size()) {
                            part = (StreamPart)StreamTransferManager.this.queue.take();
                            if (part == StreamPart.POISON) {
                                StreamTransferManager.this.finishedCount++;
                                continue;
                            }
                        } else {
                            break;
                        }
                    }
                    if (part.size() < 0x500000L) {
                        log.debug("{}: Received part {} < 5 MB that needs to be handled as 'leftover'", (Object)this, (Object)part);
                        StreamPart originalPart = part;
                        part = null;
                        Object object = StreamTransferManager.this.leftoverStreamPartLock;
                        synchronized (object) {
                            if (StreamTransferManager.this.leftoverStreamPart == null) {
                                StreamTransferManager.this.leftoverStreamPart = originalPart;
                                log.debug("{}: Created new leftover part {}", (Object)this, (Object)StreamTransferManager.this.leftoverStreamPart);
                            } else {
                                if (StreamTransferManager.this.leftoverStreamPart.getPartNumber() > originalPart.getPartNumber()) {
                                    StreamPart temp = originalPart;
                                    originalPart = StreamTransferManager.this.leftoverStreamPart;
                                    StreamTransferManager.this.leftoverStreamPart = temp;
                                }
                                StreamTransferManager.this.leftoverStreamPart.getOutputStream().append(originalPart.getOutputStream());
                                log.debug("{}: Merged with existing leftover part to create {}", (Object)this, (Object)StreamTransferManager.this.leftoverStreamPart);
                                if (StreamTransferManager.this.leftoverStreamPart.size() >= 0x500000L) {
                                    log.debug("{}: Leftover part can now be uploaded as normal and reset", (Object)this);
                                    part = StreamTransferManager.this.leftoverStreamPart;
                                    StreamTransferManager.this.leftoverStreamPart = null;
                                }
                            }
                        }
                    }
                    if (part == null) continue;
                    StreamTransferManager.this.uploadStreamPart(part);
                }
            }
            catch (Throwable t) {
                throw StreamTransferManager.this.abort(t);
            }
            return null;
        }
    }
}

