/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.marble;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.marble.ObserverAdapter;
import io.reactivex.marble.SchedulerAdapter;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.ColdPublisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.SchedulerFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;

public class ColdObservable<T>
extends Observable<T>
implements TestablePublisher<T> {
    private final TestablePublisher<T> publisher;

    protected ColdObservable(TestablePublisher<T> publisher) {
        this.publisher = publisher;
    }

    public void subscribe(Subscriber<? super T> s) {
        this.publisher.subscribe(s);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.publisher.subscribe(new ObserverAdapter<T>(observer));
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return this.publisher.getSubscriptions();
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return this.publisher.getMessages();
    }

    public static <T> ColdObservable<T> create(Scheduler scheduler, Recorded<T> ... notifications) {
        return ColdObservable.create(scheduler, Arrays.asList(notifications));
    }

    public static <T> ColdObservable<T> create(final Scheduler scheduler, List<Recorded<T>> notifications) {
        ColdPublisher<T> coldPublisher = new ColdPublisher<T>(new SchedulerFactory(){

            @Override
            public org.reactivestreams.Scheduler create() {
                return new SchedulerAdapter(scheduler);
            }
        }, notifications);
        return new ColdObservable<T>(coldPublisher);
    }
}

