/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.marble;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.marble.ObserverAdapter;
import io.reactivex.marble.SchedulerAdapter;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.HotPublisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.Subscriber;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;

public class HotObservable<T>
extends Observable<T>
implements TestablePublisher<T> {
    private final TestablePublisher<T> publisher;

    protected HotObservable(TestablePublisher<T> publisher) {
        this.publisher = publisher;
    }

    public void subscribe(Subscriber<? super T> s) {
        this.publisher.subscribe(s);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.publisher.subscribe(new ObserverAdapter<T>(observer));
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return this.publisher.getSubscriptions();
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return this.publisher.getMessages();
    }

    public static <T> HotObservable<T> create(Scheduler scheduler, Recorded<T> ... notifications) {
        return HotObservable.create(scheduler, Arrays.asList(notifications));
    }

    public static <T> HotObservable<T> create(Scheduler scheduler, List<Recorded<T>> notifications) {
        HotPublisher<T> hotPublisher = new HotPublisher<T>(new SchedulerAdapter(scheduler), notifications);
        return new HotObservable<T>(hotPublisher);
    }
}

