/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.marble;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.marble.ColdObservable;
import io.reactivex.marble.ExpectFlowableException;
import io.reactivex.marble.ExpectSubscriptionsException;
import io.reactivex.marble.HotObservable;
import io.reactivex.schedulers.TestScheduler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.ExpectPublisherException;
import org.reactivestreams.ISetupSubscriptionsTest;
import org.reactivestreams.ISetupTest;
import org.reactivestreams.MarbleSchedulerState;
import org.reactivestreams.Parser;
import org.reactivestreams.Publisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.SubscriptionLog;

public class MarbleScheduler
extends Scheduler {
    private final TestScheduler testScheduler = new TestScheduler();
    private final MarbleSchedulerState state;
    private final long frameTimeFactor;

    public MarbleScheduler() {
        this(10L);
    }

    public MarbleScheduler(long frameTimeFactor) {
        this.frameTimeFactor = frameTimeFactor;
        this.state = new PatchedSchedulerState(frameTimeFactor, new MarbleSchedulerState.ISchedule(){

            @Override
            public long now() {
                return MarbleScheduler.this.now(TimeUnit.MILLISECONDS);
            }

            @Override
            public void schedule(Runnable runnable, long time) {
                MarbleScheduler.this.createWorker().schedule(runnable, time, TimeUnit.MILLISECONDS);
            }
        }, ((Object)((Object)this)).getClass());
    }

    public long now(@NonNull TimeUnit unit) {
        return this.testScheduler.now(unit);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.testScheduler.advanceTimeBy(delayTime, unit);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        this.testScheduler.advanceTimeTo(delayTime, unit);
    }

    public void triggerActions() {
        this.testScheduler.triggerActions();
    }

    @NonNull
    public Scheduler.Worker createWorker() {
        return this.testScheduler.createWorker();
    }

    public <T> ColdObservable<T> createColdObservable(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return ColdObservable.create((Scheduler)this, notifications);
    }

    public <T> ColdObservable<T> createColdObservable(String marbles) {
        return this.createColdObservable(marbles, null);
    }

    public <T> HotObservable<T> createHotObservable(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return HotObservable.create((Scheduler)this, notifications);
    }

    public <T> HotObservable<T> createHotObservable(String marbles) {
        return this.createHotObservable(marbles, null);
    }

    public long createTime(String marbles) {
        int endIndex = marbles.indexOf("|");
        if (endIndex == -1) {
            throw new RuntimeException("Marble diagram for time should have a completion marker '|'");
        }
        return (long)endIndex * this.frameTimeFactor;
    }

    public void flush() {
        this.testScheduler.advanceTimeTo(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        try {
            this.state.flush();
        }
        catch (ExpectPublisherException ex) {
            throw new ExpectFlowableException(ex.getMessage());
        }
        catch (org.reactivestreams.ExpectSubscriptionsException ex) {
            throw new ExpectSubscriptionsException(ex.getMessage());
        }
    }

    public <T> ISetupTest expectObservable(Observable<T> observable) {
        return this.expectObservable(observable, null);
    }

    public <T> ISetupTest expectObservable(Observable<T> observable, String unsubscriptionMarbles) {
        return this.state.expectPublisher(observable.toFlowable(BackpressureStrategy.BUFFER), unsubscriptionMarbles);
    }

    public <T> ISetupTest expectFlowable(Flowable<T> flowable) {
        return this.expectFlowable(flowable, null);
    }

    public <T> ISetupTest expectFlowable(Flowable<T> flowable, String unsubscriptionMarbles) {
        return this.state.expectPublisher(flowable, unsubscriptionMarbles);
    }

    public ISetupSubscriptionsTest expectSubscriptions(List<SubscriptionLog> subscriptions) {
        return this.state.expectSubscriptions(subscriptions);
    }

    public static class PatchedSchedulerState
    extends MarbleSchedulerState {
        public PatchedSchedulerState(long frameTimeFactor, MarbleSchedulerState.ISchedule scheduler, Class schedulerClass) {
            super(frameTimeFactor, scheduler, schedulerClass);
        }

        @Override
        protected Object materializeInnerStreamWhenNeeded(Object value) {
            if (value instanceof Observable) {
                Flowable flowable = ((Observable)value).toFlowable(BackpressureStrategy.BUFFER);
                return this.materializeInnerPublisher((Publisher)flowable, this.scheduler);
            }
            return super.materializeInnerStreamWhenNeeded(value);
        }
    }
}

