/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.marble;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ObserverAdapter<T>
implements Subscriber<T> {
    private Observer<? super T> observer;

    ObserverAdapter(Observer<? super T> observer) {
        this.observer = observer;
    }

    public void onSubscribe(final Subscription subscription) {
        this.observer.onSubscribe(new Disposable(){
            private boolean disposed = false;

            public void dispose() {
                this.disposed = true;
                subscription.cancel();
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        });
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        this.observer.onNext(t);
    }

    public void onError(Throwable t) {
        this.observer.onError(t);
    }

    public void onComplete() {
        this.observer.onComplete();
    }
}

