/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Recorded;
import org.reactivestreams.Scheduler;
import org.reactivestreams.SchedulerFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;

public class ColdPublisher<T>
implements TestablePublisher<T> {
    private final SchedulerFactory schedulerFactory;
    private final List<Recorded<T>> recordedNotifications;
    private final List<SubscriptionLog> subscriptions = new ArrayList<SubscriptionLog>();

    public ColdPublisher(SchedulerFactory schedulerFactory, List<Recorded<T>> notifications) {
        this.schedulerFactory = schedulerFactory;
        this.recordedNotifications = notifications;
    }

    public void subscribe(final Subscriber<? super T> observer) {
        final Scheduler scheduler = this.schedulerFactory.create();
        final SubscriptionLog subscriptionLog = new SubscriptionLog(scheduler.now(TimeUnit.MILLISECONDS));
        this.subscriptions.add(subscriptionLog);
        final int subscriptionIndex = this.subscriptions.size() - 1;
        for (final Recorded<T> event : this.recordedNotifications) {
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    event.value.accept(observer);
                    if (!event.value.isOnNext()) {
                        ColdPublisher.this.endSubscriptions(event.time);
                    }
                }
            }, event.time, TimeUnit.MILLISECONDS);
        }
        observer.onSubscribe(new Subscription(){
            private boolean disposed = false;

            public void request(long n) {
            }

            public void cancel() {
                this.disposed = true;
                ColdPublisher.this.subscriptions.set(subscriptionIndex, new SubscriptionLog(subscriptionLog.subscribe, scheduler.now(TimeUnit.MILLISECONDS)));
                scheduler.dispose();
            }
        });
    }

    private void endSubscriptions(long time) {
        for (int i = 0; i < this.subscriptions.size(); ++i) {
            SubscriptionLog subscription = this.subscriptions.get(i);
            if (!subscription.doesNeverEnd()) continue;
            this.subscriptions.set(i, new SubscriptionLog(subscription.subscribe, time));
        }
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return Collections.unmodifiableList(this.subscriptions);
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return Collections.unmodifiableList(this.recordedNotifications);
    }
}

