/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.Scheduler;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;

public class HotPublisher<T>
implements Publisher<T>,
TestablePublisher<T> {
    private final List<Recorded<T>> notifications;
    private final List<Subscriber<? super T>> observers = new ArrayList<Subscriber<? super T>>();
    private final Scheduler scheduler;
    List<SubscriptionLog> subscriptions = new ArrayList<SubscriptionLog>();

    public HotPublisher(Scheduler scheduler, List<Recorded<T>> notifications) {
        this.scheduler = scheduler;
        this.notifications = notifications;
        this.scheduleNotifications();
    }

    private void scheduleNotifications() {
        for (final Recorded<T> event : this.notifications) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Subscriber observer : new ArrayList(HotPublisher.this.observers)) {
                        event.value.accept(observer);
                        if (event.value.isOnNext()) continue;
                        HotPublisher.this.endSubscriptions(event.time);
                    }
                }
            }, event.time, TimeUnit.MILLISECONDS);
        }
    }

    private void endSubscriptions(long time) {
        for (int i = 0; i < this.subscriptions.size(); ++i) {
            SubscriptionLog subscription = this.subscriptions.get(i);
            if (!subscription.doesNeverEnd()) continue;
            this.subscriptions.set(i, new SubscriptionLog(subscription.subscribe, time));
        }
    }

    public void subscribe(final Subscriber<? super T> subscriber) {
        this.observers.add(subscriber);
        final SubscriptionLog subscriptionLog = new SubscriptionLog(this.scheduler.now(TimeUnit.MILLISECONDS));
        this.subscriptions.add(subscriptionLog);
        final int subscriptionIndex = this.subscriptions.size() - 1;
        subscriber.onSubscribe(new Subscription(){

            public void request(long l) {
            }

            public void cancel() {
                HotPublisher.this.observers.remove(subscriber);
                HotPublisher.this.subscriptions.set(subscriptionIndex, new SubscriptionLog(subscriptionLog.subscribe, HotPublisher.this.scheduler.now(TimeUnit.MILLISECONDS)));
            }
        });
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return Collections.unmodifiableList(this.subscriptions);
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return Collections.unmodifiableList(this.notifications);
    }
}

