/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.ExceptionHelper;
import org.reactivestreams.ExpectPublisherException;
import org.reactivestreams.ExpectSubscriptionsException;
import org.reactivestreams.ISetupSubscriptionsTest;
import org.reactivestreams.ISetupTest;
import org.reactivestreams.Notification;
import org.reactivestreams.Parser;
import org.reactivestreams.Publisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.RecordedStreamComparator;
import org.reactivestreams.SetupTestSupport;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.SubscriptionLog;

public class MarbleSchedulerState {
    private final List<ITestOnFlush> flushTests = new ArrayList<ITestOnFlush>();
    private final long frameTimeFactor;
    protected final ISchedule scheduler;
    private final Class schedulerClass;

    public MarbleSchedulerState(long frameTimeFactor, ISchedule scheduler, Class schedulerClass) {
        this.frameTimeFactor = frameTimeFactor;
        this.scheduler = scheduler;
        this.schedulerClass = schedulerClass;
    }

    public void flush() {
        for (ITestOnFlush test : this.flushTests) {
            if (!test.isReady()) continue;
            test.run();
        }
    }

    public <T> ISetupTest expectPublisher(Publisher<T> publisher, String unsubscriptionMarbles) {
        String caller = ExceptionHelper.findCallerInStackTrace(this.schedulerClass, MarbleSchedulerState.class);
        FlushableTest flushTest = new FlushableTest(caller);
        ArrayList actual = new ArrayList();
        flushTest.actual = actual;
        long unsubscriptionFrame = Long.MAX_VALUE;
        if (unsubscriptionMarbles != null) {
            unsubscriptionFrame = Parser.parseMarblesAsSubscriptions((String)unsubscriptionMarbles, (long)this.frameTimeFactor).unsubscribe;
        }
        final SubscriberForExpect subscriber = new SubscriberForExpect(actual, this.scheduler);
        publisher.subscribe(subscriber);
        if (unsubscriptionFrame != Long.MAX_VALUE) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    subscriber.subscription.cancel();
                }
            }, unsubscriptionFrame);
        }
        this.flushTests.add(flushTest);
        return new SetupTest(flushTest, this.frameTimeFactor);
    }

    protected List<Recorded<Object>> materializeInnerPublisher(Publisher publisher, final ISchedule clock) {
        final ArrayList<Recorded<Object>> messages = new ArrayList<Recorded<Object>>();
        final long outerFrame = clock.now();
        publisher.subscribe(new Subscriber(){

            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            public void onNext(Object x) {
                messages.add(new Recorded<Object>(clock.now() - outerFrame, Notification.createOnNext(x)));
            }

            public void onError(Throwable throwable) {
                messages.add(new Recorded(clock.now() - outerFrame, Notification.createOnError(throwable)));
            }

            public void onComplete() {
                messages.add(new Recorded(clock.now() - outerFrame, Notification.createOnComplete()));
            }
        });
        return messages;
    }

    protected Object materializeInnerStreamWhenNeeded(Object value) {
        if (value instanceof Publisher) {
            return this.materializeInnerPublisher((Publisher)value, this.scheduler);
        }
        return value;
    }

    public ISetupSubscriptionsTest expectSubscriptions(List<SubscriptionLog> subscriptions) {
        String caller = ExceptionHelper.findCallerInStackTrace(this.schedulerClass, MarbleSchedulerState.class);
        FlushableSubscriptionTest flushTest = new FlushableSubscriptionTest(caller);
        flushTest.actual = subscriptions;
        this.flushTests.add(flushTest);
        return new SetupSubscriptionsTest(flushTest, this.frameTimeFactor);
    }

    class FlushableSubscriptionTest
    implements ITestOnFlush {
        private final String caller;
        private boolean ready;
        public List<SubscriptionLog> actual;
        public List<SubscriptionLog> expected;

        public FlushableSubscriptionTest(String caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            if (this.actual.size() != this.expected.size()) {
                throw new ExpectSubscriptionsException(this.expected.size() + " subscription(s) expected, only " + this.actual.size() + " observed", this.caller);
            }
            for (int i = 0; i < this.actual.size(); ++i) {
                if ((this.actual.get(i) == null || this.actual.get(i).equals(this.expected.get(i))) && (this.actual.get(i) != null || this.expected.get(i) == null)) continue;
                throw new ExpectSubscriptionsException("Expected subscription was " + this.expected.get(i) + ", instead received " + this.actual.get(i), this.caller);
            }
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }
    }

    class SetupSubscriptionsTest
    implements ISetupSubscriptionsTest {
        private final FlushableSubscriptionTest flushTest;
        private final long frameTimeFactor;

        public SetupSubscriptionsTest(FlushableSubscriptionTest flushTest, long frameTimeFactor) {
            this.flushTest = flushTest;
            this.frameTimeFactor = frameTimeFactor;
        }

        @Override
        public void toBe(String ... marbles) {
            this.flushTest.ready = true;
            this.flushTest.expected = new ArrayList<SubscriptionLog>();
            for (String marble : marbles) {
                SubscriptionLog subscriptionLog = Parser.parseMarblesAsSubscriptions(marble, this.frameTimeFactor);
                this.flushTest.expected.add(subscriptionLog);
            }
        }
    }

    class FlushableTest
    implements ITestOnFlush {
        private final String caller;
        private boolean ready;
        public List<Recorded<?>> actual;
        public List expected;

        public FlushableTest(String caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            RecordedStreamComparator.StreamComparison result = new RecordedStreamComparator().compare(this.actual, this.expected);
            if (!result.streamEquals) {
                throw new ExpectPublisherException(result.toString(), this.caller);
            }
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }
    }

    static interface ITestOnFlush {
        public void run();

        public boolean isReady();
    }

    class SetupTest
    extends SetupTestSupport {
        private final FlushableTest flushTest;
        private final long frameTimeFactor;

        public SetupTest(FlushableTest flushTest, long frameTimeFactor) {
            this.flushTest = flushTest;
            this.frameTimeFactor = frameTimeFactor;
        }

        @Override
        public void toBe(String marble, Map<String, ?> values, Exception errorValue) {
            this.flushTest.ready = true;
            this.flushTest.expected = values == null ? Parser.parseMarbles(marble, null, errorValue, this.frameTimeFactor, true) : Parser.parseMarbles(marble, new HashMap(values), errorValue, this.frameTimeFactor, true);
        }
    }

    public static interface ISchedule {
        public long now();

        public void schedule(Runnable var1, long var2);
    }

    private class SubscriberForExpect<T>
    implements Subscriber<T> {
        public Subscription subscription;
        private final List<Recorded<?>> actual;
        private final ISchedule clock;

        public SubscriberForExpect(List<Recorded<?>> actual, ISchedule clock) {
            this.actual = actual;
            this.clock = clock;
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            this.subscription.request(Long.MAX_VALUE);
        }

        public void onNext(T x) {
            Object value = MarbleSchedulerState.this.materializeInnerStreamWhenNeeded(x);
            this.actual.add(new Recorded<Object>(this.clock.now(), Notification.createOnNext(value)));
        }

        public void onError(Throwable throwable) {
            this.actual.add(new Recorded(this.clock.now(), Notification.createOnError(throwable)));
        }

        public void onComplete() {
            this.actual.add(new Recorded(this.clock.now(), Notification.createOnComplete()));
        }
    }
}

