/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import org.reactivestreams.Subscriber;

public final class Notification<T> {
    private final Kind kind;
    private final Throwable throwable;
    private final T value;
    private static final Notification<Void> ON_COMPLETE = new Notification<Object>(Kind.OnComplete, null, null);

    public static <T> Notification<T> createOnNext(T t) {
        return new Notification<T>(Kind.OnNext, t, null);
    }

    public static <T> Notification<T> createOnError(Throwable e) {
        return new Notification<Object>(Kind.OnError, null, e);
    }

    public static <T> Notification<T> createOnComplete() {
        return ON_COMPLETE;
    }

    private Notification(Kind kind, T value, Throwable e) {
        this.value = value;
        this.throwable = e;
        this.kind = kind;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.isOnNext() && this.value != null;
    }

    public boolean hasThrowable() {
        return this.isOnError() && this.throwable != null;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isOnError() {
        return this.getKind() == Kind.OnError;
    }

    public boolean isOnComplete() {
        return this.getKind() == Kind.OnComplete;
    }

    public boolean isOnNext() {
        return this.getKind() == Kind.OnNext;
    }

    public void accept(Subscriber<? super T> subscriber) {
        if (this.kind == Kind.OnNext) {
            subscriber.onNext(this.getValue());
        } else if (this.kind == Kind.OnComplete) {
            subscriber.onComplete();
        } else {
            subscriber.onError(this.getThrowable());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(64).append('[').append(super.toString()).append(' ').append((Object)this.getKind());
        if (this.hasValue()) {
            str.append(' ').append(this.getValue());
        }
        if (this.hasThrowable()) {
            str.append(' ').append(this.getThrowable().getMessage());
        }
        str.append(']');
        return str.toString();
    }

    public int hashCode() {
        int hash = this.getKind().hashCode();
        if (this.hasValue()) {
            hash = hash * 31 + this.getValue().hashCode();
        }
        if (this.hasThrowable()) {
            hash = hash * 31 + this.getThrowable().hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Notification notification = (Notification)obj;
        return notification.getKind() == this.getKind() && (this.value == notification.value || this.value != null && this.value.equals(notification.value)) && (this.throwable == notification.throwable || this.throwable != null && this.throwable.equals(notification.throwable));
    }

    public static enum Kind {
        OnNext,
        OnError,
        OnComplete;

    }
}

