/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Notification;
import org.reactivestreams.Recorded;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;

public class Parser {
    public static <T> List<Recorded<T>> parseMarbles(String marbles, Map<String, T> values, Exception errorValue, long frameTimeFactor, boolean materializeInnerObservables) {
        if (marbles.indexOf(33) != -1) {
            throw new IllegalArgumentException("Conventional marble diagrams cannot have the unsubscription marker '!'");
        }
        int len = marbles.length();
        ArrayList<Recorded<T>> testMessages = new ArrayList<Recorded<T>>();
        int subIndex = marbles.indexOf(94);
        long frameOffset = subIndex == -1 ? 0L : (long)subIndex * -frameTimeFactor;
        long groupStart = -1L;
        for (int i = 0; i < len; ++i) {
            long frame = (long)i * frameTimeFactor + frameOffset;
            Notification<Object> notification = null;
            char c = marbles.charAt(i);
            switch (c) {
                case ' ': 
                case '-': {
                    break;
                }
                case '(': {
                    groupStart = frame;
                    break;
                }
                case ')': {
                    groupStart = -1L;
                    break;
                }
                case '|': {
                    notification = Notification.createOnComplete();
                    break;
                }
                case '^': {
                    break;
                }
                case '#': {
                    notification = Notification.createOnError(errorValue);
                    break;
                }
                default: {
                    Object value;
                    if (values == null) {
                        value = String.valueOf(c);
                    } else {
                        value = values.get(String.valueOf(c));
                        if (materializeInnerObservables && value instanceof TestablePublisher) {
                            value = ((TestablePublisher)value).getMessages();
                        }
                    }
                    notification = Notification.createOnNext(value);
                }
            }
            if (notification == null) continue;
            long messageFrame = groupStart > -1L ? groupStart : frame;
            testMessages.add(new Recorded(messageFrame, notification));
        }
        return testMessages;
    }

    public static <T> List<Recorded<T>> parseMarbles(String marbles, Map<String, T> values, long frameTimeFactor) {
        return Parser.parseMarbles(marbles, values, null, frameTimeFactor);
    }

    public static <T> List<Recorded<T>> parseMarbles(String marbles, Map<String, T> values, Exception errorValue, long frameTimeFactor) {
        return Parser.parseMarbles(marbles, values, errorValue, frameTimeFactor, false);
    }

    public static List<Recorded<String>> parseMarbles(String marbles, long frameTimeFactor) {
        return Parser.parseMarbles(marbles, null, frameTimeFactor);
    }

    public static SubscriptionLog parseMarblesAsSubscriptions(String marbles, long frameTimeFactor) {
        int len = marbles.length();
        long groupStart = -1L;
        long subscriptionFrame = Long.MAX_VALUE;
        long unsubscriptionFrame = Long.MAX_VALUE;
        block7: for (int i = 0; i < len; ++i) {
            long frame = (long)i * frameTimeFactor;
            char c = marbles.charAt(i);
            switch (c) {
                case ' ': 
                case '-': {
                    continue block7;
                }
                case '(': {
                    groupStart = frame;
                    continue block7;
                }
                case ')': {
                    groupStart = -1L;
                    continue block7;
                }
                case '^': {
                    if (subscriptionFrame != Long.MAX_VALUE) {
                        throw new IllegalArgumentException("Found a second subscription point '^' in a subscription marble diagram. There can only be one.");
                    }
                    subscriptionFrame = groupStart > -1L ? groupStart : frame;
                    continue block7;
                }
                case '!': {
                    if (unsubscriptionFrame != Long.MAX_VALUE) {
                        throw new IllegalArgumentException("Found a second subscription point '^' in a subscription marble diagram. There can only be one.");
                    }
                    unsubscriptionFrame = groupStart > -1L ? groupStart : frame;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("There can only be '^' and '!' markers in a subscription marble diagram. Found instead '' + c + ''.");
                }
            }
        }
        if (unsubscriptionFrame < 0L) {
            return new SubscriptionLog(subscriptionFrame);
        }
        return new SubscriptionLog(subscriptionFrame, unsubscriptionFrame);
    }
}

