/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import org.reactivestreams.Notification;

public class Recorded<T> {
    public final Notification<T> value;
    public final long time;

    public Recorded(long time, Notification<T> value) {
        this.time = time;
        this.value = value;
    }

    public String toString() {
        String valueString;
        switch (this.value.getKind()) {
            case OnComplete: {
                valueString = "On Complete";
                break;
            }
            case OnError: {
                valueString = "On Error";
                break;
            }
            default: {
                valueString = "On Next: " + this.value.getValue();
            }
        }
        return "{\n  time = " + this.time + "\n  " + valueString + "\n}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recorded recorded = (Recorded)o;
        if (this.time != recorded.time) {
            return false;
        }
        return !(this.value == null ? recorded.value != null : !this.notificationsAreEqual(this.value, recorded.value));
    }

    private boolean notificationsAreEqual(Notification<?> first, Notification<?> second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.isOnError() && second.isOnError()) {
            return true;
        }
        return first.equals(second);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }
}

