/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.reactivestreams.Recorded;

public class RecordedStreamComparator {
    public StreamComparison compare(List<Recorded<?>> actualRecords, List<Recorded<?>> expectedRecords) {
        ArrayList<EventComparison> unitComparisons = new ArrayList<EventComparison>();
        ArrayList onlyOnExpected = new ArrayList(expectedRecords);
        onlyOnExpected.removeAll(actualRecords);
        for (Recorded recorded : onlyOnExpected) {
            unitComparisons.add(new EventComparison(recorded, EventComparisonResult.ONLY_ON_EXPECTED));
        }
        ArrayList onlyOnActual = new ArrayList(actualRecords);
        onlyOnActual.removeAll(expectedRecords);
        for (Recorded recorded : onlyOnActual) {
            unitComparisons.add(new EventComparison(recorded, EventComparisonResult.ONLY_ON_ACTUAL));
        }
        boolean bl = unitComparisons.isEmpty();
        for (Recorded<?> record : actualRecords) {
            if (onlyOnActual.contains(record) || onlyOnExpected.contains(record)) continue;
            unitComparisons.add(new EventComparison(record, EventComparisonResult.EQUALS));
        }
        Collections.sort(unitComparisons, new Comparator<EventComparison>(){

            @Override
            public int compare(EventComparison first, EventComparison second) {
                int diff = new Long(first.record.time - second.record.time).intValue();
                if (diff == 0) {
                    if (first.record.value.isOnComplete() || first.record.value.isOnError()) {
                        return Integer.MAX_VALUE;
                    }
                    if (second.record.value.isOnComplete() || second.record.value.isOnError()) {
                        return Integer.MIN_VALUE;
                    }
                }
                return diff;
            }
        });
        return new StreamComparison(bl, unitComparisons);
    }

    public static class EventComparison {
        public final Recorded<?> record;
        public final EventComparisonResult result;

        public EventComparison(Recorded<?> record, EventComparisonResult result) {
            this.record = record;
            this.result = result;
        }

        public String toString() {
            switch (this.result) {
                case EQUALS: {
                    return "= " + this.record.toString().replace("\n", "\n= ");
                }
                case ONLY_ON_ACTUAL: {
                    return "+ " + this.record.toString().replace("\n", "\n+ ");
                }
                case ONLY_ON_EXPECTED: {
                    return "- " + this.record.toString().replace("\n", "\n- ");
                }
            }
            throw new RuntimeException("should not happen");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventComparison that = (EventComparison)o;
            if (!this.record.equals(that.record)) {
                return false;
            }
            return this.result == that.result;
        }

        public int hashCode() {
            int result1 = this.record.hashCode();
            result1 = 31 * result1 + this.result.hashCode();
            return result1;
        }
    }

    public static enum EventComparisonResult {
        EQUALS,
        ONLY_ON_ACTUAL,
        ONLY_ON_EXPECTED;

    }

    public static class StreamComparison {
        public final boolean streamEquals;
        public final List<EventComparison> unitComparisons;

        public StreamComparison(boolean equals, List<EventComparison> comparisons) {
            this.streamEquals = equals;
            this.unitComparisons = comparisons;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.streamEquals) {
                builder.append("Streams are equal");
            } else {
                builder.append("Streams are not equal, details below:");
                EventComparisonResult currentMode = null;
                for (EventComparison comparison : this.unitComparisons) {
                    if (currentMode == comparison.result) {
                        builder.append("\n");
                    } else {
                        currentMode = comparison.result;
                        switch (currentMode) {
                            case EQUALS: {
                                builder.append("\n=   On actual & expected streams\n");
                                break;
                            }
                            case ONLY_ON_ACTUAL: {
                                builder.append("\n+   On actual stream\n");
                                break;
                            }
                            case ONLY_ON_EXPECTED: {
                                builder.append("\n-   On expected stream\n");
                            }
                        }
                    }
                    builder.append(comparison);
                }
            }
            return builder.toString();
        }
    }
}

